/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.event.transformation.impl;

import io.axoniq.axonserver.connector.event.transformation.ActiveTransformation;
import io.axoniq.axonserver.connector.event.transformation.EventTransformation;
import io.axoniq.axonserver.connector.event.transformation.Transformer;
import io.axoniq.axonserver.connector.event.transformation.impl.EventTransformationService;
import io.axoniq.axonserver.connector.event.transformation.impl.TransformationStreamAppender;
import java.util.concurrent.CompletableFuture;

public class DefaultActiveTransformation
implements ActiveTransformation {
    private final String transformationId;
    private final Long currentSequence;
    private final EventTransformationService service;

    DefaultActiveTransformation(String transformationId, Long currentSequence, EventTransformationService service) {
        this.transformationId = transformationId;
        this.currentSequence = currentSequence;
        this.service = service;
    }

    @Override
    public CompletableFuture<ActiveTransformation> transform(Transformer transformer) {
        EventTransformationService.TransformationStream transformationStream = this.service.transformationStream(this.transformationId);
        TransformationStreamAppender appender = new TransformationStreamAppender(transformationStream, this.currentSequence);
        transformer.transform(appender);
        return appender.complete().thenApply(seq -> new DefaultActiveTransformation(this.transformationId, (Long)seq, this.service));
    }

    @Override
    public CompletableFuture<EventTransformation> startApplying() {
        return this.service.startApplying(this.transformationId, this.currentSequence).thenCompose(unused -> this.service.transformationById(this.transformationId));
    }

    @Override
    public CompletableFuture<EventTransformation> cancel() {
        return this.service.cancel(this.transformationId).thenCompose(unused -> this.service.transformationById(this.transformationId));
    }
}

