/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.observation;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.support.observation.AbstractListenerObservation;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.jspecify.annotations.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

public class SqsListenerObservation {

    public static class SqsSpecifics
    implements AbstractListenerObservation.Specifics<Context> {
        private static final DefaultConvention LISTENER_CONVENTION_INSTANCE = new DefaultConvention();
        private static final Documentation LISTENER_DOCUMENTATION_INSTANCE = new Documentation();

        @Override
        public Context createContext(Message<?> message) {
            return new Context(message);
        }

        @Override
        public ObservationConvention<Context> getDefaultConvention() {
            return LISTENER_CONVENTION_INSTANCE;
        }

        @Override
        public ObservationDocumentation getDocumentation() {
            return LISTENER_DOCUMENTATION_INSTANCE;
        }
    }

    public static class DefaultConvention
    extends AbstractListenerObservation.Convention<Context>
    implements Convention {
        @Override
        protected String getSourceKind() {
            return "queue";
        }

        @Override
        protected String getMessagingSystem() {
            return "sqs";
        }

        @Override
        protected KeyValues getSpecificHighCardinalityKeyValues(Context context) {
            String messageDeduplicationId = context.getMessageDeduplicationId();
            String messageGroupId = context.getMessageGroupId();
            return StringUtils.hasText((String)messageGroupId) && StringUtils.hasText((String)messageDeduplicationId) ? KeyValues.of((KeyValue[])new KeyValue[]{Documentation.HighCardinalityTags.MESSAGE_GROUP_ID.withValue(messageGroupId), Documentation.HighCardinalityTags.MESSAGE_DEDUPLICATION_ID.withValue(messageDeduplicationId)}) : KeyValues.empty();
        }
    }

    public static class Context
    extends AbstractListenerObservation.Context {
        private final String messageGroupId;
        private final String messageDeduplicationId;

        public Context(Message<?> message) {
            super(message, Context.getQueueName(message));
            this.messageGroupId = message.getHeaders().containsKey((Object)"Sqs_Msa_MessageGroupId") ? MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_MessageGroupId") : "";
            this.messageDeduplicationId = message.getHeaders().containsKey((Object)"Sqs_Msa_MessageDeduplicationId") ? MessageHeaderUtils.getHeaderAsString(message, "Sqs_Msa_MessageDeduplicationId") : "";
            this.setRemoteServiceName("AWS SQS");
        }

        private static String getQueueName(Message<?> message) {
            return MessageHeaderUtils.getHeaderAsString(message, "Sqs_QueueName");
        }

        public String getMessageGroupId() {
            return this.messageGroupId;
        }

        public String getMessageDeduplicationId() {
            return this.messageDeduplicationId;
        }
    }

    public static interface Convention
    extends ObservationConvention<Context> {
        default public boolean supportsContext(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Observation.Context context) {
            return context instanceof Context;
        }

        default public String getName() {
            return "spring.cloud.aws.sqs.listener";
        }
    }

    public static class Documentation
    extends AbstractListenerObservation.Documentation {
        @Override
        protected Class<? extends ObservationConvention<? extends Observation.Context>> getSpecificDefaultConvention() {
            return DefaultConvention.class;
        }

        @Override
        protected KeyName[] getSpecificHighCardinalityKeyNames() {
            return HighCardinalityTags.values();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum HighCardinalityTags implements KeyName
        {
            MESSAGE_GROUP_ID{

                public @NonNull String asString() {
                    return "messaging.message.message-group.id";
                }
            }
            ,
            MESSAGE_DEDUPLICATION_ID{

                public @NonNull String asString() {
                    return "messaging.message.message-deduplication.id";
                }
            };

        }
    }
}

