/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.observation;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import io.micrometer.observation.transport.ReceiverContext;
import org.jspecify.annotations.NonNull;
import org.springframework.messaging.Message;

public abstract class AbstractListenerObservation {

    public static interface Specifics<ContextType extends Context> {
        public ContextType createContext(Message<?> var1);

        public ObservationConvention<ContextType> getDefaultConvention();

        public ObservationDocumentation getDocumentation();
    }

    public static abstract class Context
    extends ReceiverContext<Message<?>> {
        private final Message<?> message;
        private final String messageId;
        private final String sourceName;

        protected Context(Message<?> message, String sourceName) {
            super((carrier, key) -> (String)carrier.getHeaders().get((Object)key, String.class));
            this.setCarrier(message);
            this.message = message;
            this.messageId = MessageHeaderUtils.getId(message);
            this.sourceName = sourceName;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public String getSourceName() {
            return this.sourceName;
        }
    }

    public static abstract class Documentation
    implements ObservationDocumentation {
        KeyName[] EMPTY = new KeyName[0];

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return this.getSpecificDefaultConvention();
        }

        protected abstract Class<? extends ObservationConvention<? extends Observation.Context>> getSpecificDefaultConvention();

        public @NonNull KeyName[] getLowCardinalityKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{LowCardinalityTags.values(), this.getSpecificLowCardinalityKeyNames()});
        }

        protected KeyName[] getSpecificLowCardinalityKeyNames() {
            return this.EMPTY;
        }

        public @NonNull KeyName[] getHighCardinalityKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{HighCardinalityTags.values(), this.getSpecificHighCardinalityKeyNames()});
        }

        protected KeyName[] getSpecificHighCardinalityKeyNames() {
            return this.EMPTY;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum LowCardinalityTags implements KeyName
        {
            MESSAGING_SYSTEM{

                public @NonNull String asString() {
                    return "messaging.system";
                }
            }
            ,
            MESSAGING_OPERATION{

                public @NonNull String asString() {
                    return "messaging.operation";
                }
            }
            ,
            MESSAGING_SOURCE_NAME{

                public @NonNull String asString() {
                    return "messaging.source.name";
                }
            }
            ,
            MESSAGING_SOURCE_KIND{

                public @NonNull String asString() {
                    return "messaging.source.kind";
                }
            };

        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum HighCardinalityTags implements KeyName
        {
            MESSAGE_ID{

                public @NonNull String asString() {
                    return "messaging.message.id";
                }
            };

        }
    }

    public static abstract class Convention<ContextType extends Context>
    implements ObservationConvention<ContextType> {
        public @NonNull KeyValues getLowCardinalityKeyValues(ContextType context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{Documentation.LowCardinalityTags.MESSAGING_SYSTEM.withValue(this.getMessagingSystem()), Documentation.LowCardinalityTags.MESSAGING_OPERATION.withValue("receive"), Documentation.LowCardinalityTags.MESSAGING_SOURCE_NAME.withValue(((Context)((Object)context)).getSourceName()), Documentation.LowCardinalityTags.MESSAGING_SOURCE_KIND.withValue(this.getSourceKind())}).and((Iterable)this.getSpecificLowCardinalityKeyValues(context)).and((Iterable)this.getCustomLowCardinalityKeyValues(context));
        }

        protected KeyValues getSpecificLowCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        protected KeyValues getCustomLowCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        public @NonNull KeyValues getHighCardinalityKeyValues(ContextType context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{Documentation.HighCardinalityTags.MESSAGE_ID.withValue(((Context)((Object)context)).getMessageId())}).and((Iterable)this.getSpecificHighCardinalityKeyValues(context)).and((Iterable)this.getCustomHighCardinalityKeyValues(context));
        }

        protected KeyValues getSpecificHighCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        protected KeyValues getCustomHighCardinalityKeyValues(ContextType context) {
            return KeyValues.empty();
        }

        public String getContextualName(ContextType context) {
            return ((Context)((Object)context)).getSourceName() + " receive";
        }

        public String getName() {
            return "spring.aws." + this.getMessagingSystem() + ".listener";
        }

        protected abstract String getSourceKind();

        protected abstract String getMessagingSystem();
    }
}

