/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.config.MessageConverterFactory;
import io.awspring.cloud.sqs.support.converter.AbstractMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.HeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.SimpleClassMatchingMessageConverter;
import io.awspring.cloud.sqs.support.converter.SqsHeaderMapper;
import io.awspring.cloud.sqs.support.converter.SqsMessageConversionContext;
import java.util.ArrayList;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.model.Message;
import tools.jackson.databind.json.JsonMapper;

public class SqsMessagingMessageConverter
extends AbstractMessagingMessageConverter<Message> {
    public SqsMessagingMessageConverter(JsonMapper jsonMapper) {
        super((MessageConverter)SqsMessagingMessageConverter.createDefaultCompositeMessageConverter(Objects.requireNonNull(jsonMapper, "jsonMapper cannot be null")));
    }

    public SqsMessagingMessageConverter() {
        super((MessageConverter)SqsMessagingMessageConverter.createDefaultCompositeMessageConverter());
    }

    private static CompositeMessageConverter createDefaultCompositeMessageConverter() {
        return SqsMessagingMessageConverter.createDefaultCompositeMessageConverter(null);
    }

    private static CompositeMessageConverter createDefaultCompositeMessageConverter(@Nullable JsonMapper jsonMapper) {
        ArrayList<SimpleClassMatchingMessageConverter> messageConverters = new ArrayList<SimpleClassMatchingMessageConverter>();
        messageConverters.add(SqsMessagingMessageConverter.createClassMatchingMessageConverter());
        messageConverters.add((SimpleClassMatchingMessageConverter)SqsMessagingMessageConverter.createStringMessageConverter());
        messageConverters.add((SimpleClassMatchingMessageConverter)MessageConverterFactory.createJacksonJsonMessageConverter(jsonMapper));
        return new CompositeMessageConverter(messageConverters);
    }

    @Override
    protected HeaderMapper<Message> createDefaultHeaderMapper() {
        return new SqsHeaderMapper();
    }

    @Override
    protected Object getPayloadToDeserialize(Message message) {
        return message.body();
    }

    @Override
    public MessageConversionContext createMessageConversionContext() {
        return new SqsMessageConversionContext();
    }

    @Override
    protected Message doConvertMessage(Message messageWithHeaders, Object payload) {
        Assert.isInstanceOf(String.class, (Object)payload, (String)"payload must be instance of String");
        return (Message)messageWithHeaders.toBuilder().body((String)payload).build();
    }

    private static SimpleClassMatchingMessageConverter createClassMatchingMessageConverter() {
        SimpleClassMatchingMessageConverter matchingMessageConverter = new SimpleClassMatchingMessageConverter();
        matchingMessageConverter.setSerializedPayloadClass(String.class);
        return matchingMessageConverter;
    }

    private static StringMessageConverter createStringMessageConverter() {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        return stringMessageConverter;
    }
}

