/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.support.converter.ContextAwareHeaderMapper;
import io.awspring.cloud.sqs.support.converter.ContextAwareMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.HeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.SimpleClassMatchingMessageConverter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public abstract class AbstractMessagingMessageConverter<S>
implements ContextAwareMessagingMessageConverter<S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessagingMessageConverter.class);
    private String typeHeader = "JavaType";
    private MessageConverter payloadMessageConverter;
    private HeaderMapper<S> headerMapper;
    private static final Function<Message<?>, Class<?>> DEFAULT_PAYLOAD_TYPE_MAPPER = msg -> AbstractMessagingMessageConverter.headerTypeMapping(msg, "JavaType");
    private Function<Message<?>, Class<?>> payloadTypeMapper = DEFAULT_PAYLOAD_TYPE_MAPPER;
    private Function<Message<?>, String> payloadTypeHeaderFunction = message -> message.getPayload().getClass().getName();

    protected AbstractMessagingMessageConverter(MessageConverter messageConverter) {
        this.headerMapper = this.createDefaultHeaderMapper();
        this.payloadMessageConverter = messageConverter;
    }

    public boolean isUsingDefaultPayloadTypeMapper() {
        return this.payloadTypeMapper == DEFAULT_PAYLOAD_TYPE_MAPPER;
    }

    public void setPayloadTypeMapper(Function<Message<?>, Class<?>> payloadTypeMapper) {
        Assert.notNull(payloadTypeMapper, (String)"payloadTypeMapper cannot be null");
        this.payloadTypeMapper = payloadTypeMapper;
    }

    public void setPayloadMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter cannot be null");
        this.payloadMessageConverter = messageConverter;
    }

    public MessageConverter getPayloadMessageConverter() {
        return this.payloadMessageConverter;
    }

    public void setPayloadTypeHeader(String typeHeader) {
        Assert.notNull((Object)typeHeader, (String)"typeHeader cannot be null");
        this.typeHeader = typeHeader;
        this.payloadTypeMapper = msg -> AbstractMessagingMessageConverter.headerTypeMapping(msg, typeHeader);
    }

    public void setPayloadTypeHeaderValueFunction(Function<Message<?>, String> payloadTypeHeaderFunction) {
        Assert.notNull(payloadTypeHeaderFunction, (String)"payloadTypeHeaderFunction cannot be null");
        this.payloadTypeHeaderFunction = payloadTypeHeaderFunction;
    }

    public void setHeaderMapper(HeaderMapper<S> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper cannot be null");
        this.headerMapper = headerMapper;
    }

    public void doNotSendPayloadTypeHeader() {
        this.payloadTypeHeaderFunction = message -> null;
    }

    protected abstract HeaderMapper<S> createDefaultHeaderMapper();

    @Override
    public Message<?> toMessagingMessage(S message, @Nullable MessageConversionContext context) {
        MessageHeaders messageHeaders = this.createMessageHeaders(message, context);
        return MessageBuilder.createMessage((Object)this.convertPayload(message, messageHeaders, context), (MessageHeaders)messageHeaders);
    }

    private MessageHeaders createMessageHeaders(S message, @Nullable MessageConversionContext context) {
        MessageHeaders messageHeaders = this.headerMapper.toHeaders(message);
        return context != null && this.headerMapper instanceof ContextAwareHeaderMapper ? MessageHeaderUtils.addHeadersIfAbsent(messageHeaders, (Map<String, Object>)this.getContextHeaders(message, context)) : messageHeaders;
    }

    private MessageHeaders getContextHeaders(S message, MessageConversionContext context) {
        return ((ContextAwareHeaderMapper)this.headerMapper).createContextHeaders(message, context);
    }

    private Object convertPayload(S message, MessageHeaders messageHeaders, @Nullable MessageConversionContext context) {
        Message messagingMessage = MessageBuilder.createMessage((Object)this.getPayloadToDeserialize(message), (MessageHeaders)messageHeaders);
        Class<?> targetType = this.getTargetType(messagingMessage, context);
        return targetType != null ? Objects.requireNonNull(this.payloadMessageConverter.fromMessage(messagingMessage, targetType), "payloadMessageConverter returned null payload") : messagingMessage.getPayload();
    }

    private @Nullable Class<?> getTargetType(Message<?> messagingMessage, @Nullable MessageConversionContext context) {
        Class<?> classFromTypeMapper = this.payloadTypeMapper.apply(messagingMessage);
        return classFromTypeMapper == null && context != null && context.getPayloadClass() != null ? context.getPayloadClass() : classFromTypeMapper;
    }

    protected abstract Object getPayloadToDeserialize(S var1);

    private static @Nullable Class<?> headerTypeMapping(Message<?> message, String typeHeader) {
        String header = (String)message.getHeaders().get((Object)typeHeader, String.class);
        if (header == null) {
            return null;
        }
        try {
            return Class.forName(header);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class found with name " + header);
        }
    }

    @Override
    public MessageConversionContext createMessageConversionContext() {
        return null;
    }

    @Override
    public S fromMessagingMessage(Message<?> message, @Nullable MessageConversionContext context) {
        MessageHeaders headers = this.getMessageHeaders(message);
        Message<?> convertedMessage = this.convertPayload(message, message.getPayload());
        MessageHeaders completeHeaders = MessageHeaderUtils.addHeadersIfAbsent(headers, (Map<String, Object>)convertedMessage.getHeaders());
        S messageWithHeaders = this.headerMapper.fromHeaders(completeHeaders);
        return this.doConvertMessage(messageWithHeaders, convertedMessage.getPayload());
    }

    private Message<?> convertPayload(Message<?> message, Object payload) {
        return Objects.requireNonNull(this.payloadMessageConverter.toMessage(payload, message.getHeaders()), () -> "payloadMessageConverter returned null message for message " + message);
    }

    private MessageHeaders getMessageHeaders(Message<?> message) {
        String typeHeaderName = this.payloadTypeHeaderFunction.apply(message);
        return typeHeaderName != null ? MessageHeaderUtils.addHeaderIfAbsent(message.getHeaders(), this.typeHeader, (Object)typeHeaderName) : message.getHeaders();
    }

    protected abstract S doConvertMessage(S var1, Object var2);

    private static SimpleClassMatchingMessageConverter createClassMatchingMessageConverter() {
        SimpleClassMatchingMessageConverter matchingMessageConverter = new SimpleClassMatchingMessageConverter();
        matchingMessageConverter.setSerializedPayloadClass(String.class);
        return matchingMessageConverter;
    }

    private static StringMessageConverter createStringMessageConverter() {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        return stringMessageConverter;
    }
}

