/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementHandler;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class MessageProcessingConfiguration<T> {
    private final Collection<AsyncMessageInterceptor<T>> messageInterceptors;
    private final AsyncMessageListener<T> messageListener;
    private final AsyncErrorHandler<T> errorHandler;
    private final AcknowledgementHandler<T> acknowledgementHandler;

    private MessageProcessingConfiguration(Builder<T> builder) {
        this.messageInterceptors = builder.messageInterceptors;
        this.messageListener = builder.messageListener;
        this.errorHandler = builder.errorHandler;
        this.acknowledgementHandler = builder.acknowledgementHandler;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Collection<AsyncMessageInterceptor<T>> getMessageInterceptors() {
        return this.messageInterceptors;
    }

    public AsyncMessageListener<T> getMessageListener() {
        return this.messageListener;
    }

    public @Nullable AsyncErrorHandler<T> getErrorHandler() {
        return this.errorHandler;
    }

    public AcknowledgementHandler<T> getAckHandler() {
        return this.acknowledgementHandler;
    }

    public static class Builder<T> {
        private Collection<AsyncMessageInterceptor<T>> messageInterceptors;
        private AsyncMessageListener<T> messageListener;
        private AsyncErrorHandler<T> errorHandler;
        private AcknowledgementHandler<T> acknowledgementHandler;

        public Builder<T> interceptors(Collection<AsyncMessageInterceptor<T>> messageInterceptors) {
            this.messageInterceptors = messageInterceptors;
            return this;
        }

        public Builder<T> messageListener(AsyncMessageListener<T> messageListener) {
            this.messageListener = messageListener;
            return this;
        }

        public Builder<T> errorHandler(AsyncErrorHandler<T> errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder<T> ackHandler(AcknowledgementHandler<T> acknowledgementHandler) {
            this.acknowledgementHandler = acknowledgementHandler;
            return this;
        }

        public MessageProcessingConfiguration<T> build() {
            Assert.notNull(this.messageListener, (String)"messageListener cannot be null");
            Assert.notNull(this.acknowledgementHandler, (String)"ackHandler cannot be null");
            Assert.notNull(this.messageInterceptors, (String)"messageInterceptors cannot be null");
            return new MessageProcessingConfiguration(this);
        }
    }
}

