/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.backpressure;

import io.awspring.cloud.sqs.listener.IdentifiableContainerComponent;
import io.awspring.cloud.sqs.listener.backpressure.BackPressureHandler;
import io.awspring.cloud.sqs.listener.backpressure.BatchAwareBackPressureHandler;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ConcurrencyLimiterBlockingBackPressureHandler
implements BatchAwareBackPressureHandler,
IdentifiableContainerComponent {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrencyLimiterBlockingBackPressureHandler.class);
    private final Semaphore semaphore;
    private final int batchSize;
    private final int totalPermits;
    private final Duration acquireTimeout;
    private String id = this.getClass().getSimpleName();

    private ConcurrencyLimiterBlockingBackPressureHandler(Builder builder) {
        this.batchSize = builder.batchSize;
        this.totalPermits = builder.totalPermits;
        this.acquireTimeout = builder.acquireTimeout;
        logger.debug("ConcurrencyLimiterBlockingBackPressureHandler created with configuration totalPermits: {}, batchSize: {}, acquireTimeout: {}", new Object[]{this.totalPermits, this.batchSize, this.acquireTimeout});
        this.semaphore = new Semaphore(this.totalPermits);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int requestBatch() throws InterruptedException {
        return this.request(this.batchSize);
    }

    @Override
    public int request(int amount) throws InterruptedException {
        int acquiredPermits = this.tryAcquire(amount, this.acquireTimeout);
        if (acquiredPermits > 0) {
            return acquiredPermits;
        }
        int availablePermits = Math.min(this.semaphore.availablePermits(), amount);
        if (availablePermits > 0) {
            return this.tryAcquire(availablePermits, this.acquireTimeout);
        }
        return 0;
    }

    private int tryAcquire(int amount, Duration duration) throws InterruptedException {
        if (this.semaphore.tryAcquire(amount, duration.toMillis(), TimeUnit.MILLISECONDS)) {
            logger.debug("[{}] Acquired {} permits ({} / {} available)", new Object[]{this.id, amount, this.semaphore.availablePermits(), this.totalPermits});
            return amount;
        }
        return 0;
    }

    @Override
    public void release(int amount, BackPressureHandler.ReleaseReason reason) {
        this.semaphore.release(amount);
        logger.debug("[{}] Released {} permits ({}) ({} / {} available)", new Object[]{this.id, amount, reason, this.semaphore.availablePermits(), this.totalPermits});
    }

    @Override
    public boolean drain(Duration timeout) {
        logger.debug("[{}] Waiting for up to {} for approx. {} permits to be released", new Object[]{this.id, timeout, this.totalPermits - this.semaphore.availablePermits()});
        try {
            return this.tryAcquire(this.totalPermits, timeout) > 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("[{}] Draining interrupted", (Object)this.id);
            return false;
        }
    }

    public static class Builder {
        private int batchSize;
        private int totalPermits;
        private Duration acquireTimeout;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder totalPermits(int totalPermits) {
            this.totalPermits = totalPermits;
            return this;
        }

        public Builder acquireTimeout(Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            return this;
        }

        public ConcurrencyLimiterBlockingBackPressureHandler build() {
            Assert.noNullElements(Arrays.asList(this.batchSize, this.totalPermits, this.acquireTimeout), (String)"Missing configuration");
            Assert.isTrue((this.batchSize > 0 ? 1 : 0) != 0, (String)"The batch size must be greater than 0");
            Assert.isTrue((this.totalPermits >= this.batchSize ? 1 : 0) != 0, (String)"Total permits must be greater than the batch size");
            return new ConcurrencyLimiterBlockingBackPressureHandler(this);
        }
    }
}

