/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.config.AbstractEndpoint;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import java.time.Duration;
import java.util.Collection;
import org.jspecify.annotations.Nullable;

public class SqsEndpoint
extends AbstractEndpoint {
    private final Integer maxConcurrentMessages;
    private final Integer pollTimeoutSeconds;
    private final Integer messageVisibility;
    private final Integer maxMessagesPerPoll;
    private final @Nullable AcknowledgementMode acknowledgementMode;

    protected SqsEndpoint(SqsEndpointBuilder builder) {
        super(builder.queueNames, builder.factoryName, builder.id);
        this.maxConcurrentMessages = builder.maxConcurrentMessages;
        this.pollTimeoutSeconds = builder.pollTimeoutSeconds;
        this.messageVisibility = builder.messageVisibility;
        this.maxMessagesPerPoll = builder.maxMessagesPerPoll;
        this.acknowledgementMode = builder.acknowledgementMode;
    }

    public static SqsEndpointBuilder builder() {
        return new SqsEndpointBuilder();
    }

    public @Nullable Integer getMaxConcurrentMessages() {
        return this.maxConcurrentMessages;
    }

    public @Nullable Duration getPollTimeout() {
        return this.pollTimeoutSeconds != null ? Duration.ofSeconds(this.pollTimeoutSeconds.intValue()) : null;
    }

    public @Nullable Integer getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public @Nullable Duration getMessageVisibility() {
        return this.messageVisibility != null ? Duration.ofSeconds(this.messageVisibility.intValue()) : null;
    }

    public @Nullable AcknowledgementMode getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public static class SqsEndpointBuilder {
        private Collection<String> queueNames;
        private Integer maxConcurrentMessages;
        private Integer pollTimeoutSeconds;
        private String factoryName;
        private Integer messageVisibility;
        private String id;
        private Integer maxMessagesPerPoll;
        private @Nullable AcknowledgementMode acknowledgementMode;

        public SqsEndpointBuilder queueNames(Collection<String> queueNames) {
            this.queueNames = queueNames;
            return this;
        }

        public SqsEndpointBuilder factoryBeanName(String factoryName) {
            this.factoryName = factoryName;
            return this;
        }

        public SqsEndpointBuilder maxConcurrentMessages(Integer maxConcurrentMessages) {
            this.maxConcurrentMessages = maxConcurrentMessages;
            return this;
        }

        public SqsEndpointBuilder pollTimeoutSeconds(Integer pollTimeoutSeconds) {
            this.pollTimeoutSeconds = pollTimeoutSeconds;
            return this;
        }

        public SqsEndpointBuilder maxMessagesPerPoll(Integer maxMessagesPerPoll) {
            this.maxMessagesPerPoll = maxMessagesPerPoll;
            return this;
        }

        public SqsEndpointBuilder messageVisibility(Integer messageVisibility) {
            this.messageVisibility = messageVisibility;
            return this;
        }

        public SqsEndpointBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SqsEndpointBuilder acknowledgementMode(@Nullable AcknowledgementMode acknowledgementMode) {
            this.acknowledgementMode = acknowledgementMode;
            return this;
        }

        public SqsEndpoint build() {
            return new SqsEndpoint(this);
        }
    }
}

