/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.config.MethodPayloadTypeInferrer;
import io.awspring.cloud.sqs.support.resolver.BatchPayloadMethodArgumentResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;

public class DefaultMethodPayloadTypeInferrer
implements MethodPayloadTypeInferrer {
    @Override
    public @Nullable Class<?> inferPayloadType(Method method, List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers == null || argumentResolvers.isEmpty()) {
            return null;
        }
        List<HandlerMethodArgumentResolver> nonPayloadResolvers = argumentResolvers.stream().filter(resolver -> !this.isPayloadResolver((HandlerMethodArgumentResolver)resolver)).toList();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            MethodParameter parameter = new MethodParameter(method, i);
            if (parameter.hasParameterAnnotation(Payload.class)) {
                return this.extractClass(parameter.getGenericParameterType());
            }
            boolean supportedByNonPayloadResolver = nonPayloadResolvers.stream().anyMatch(resolver -> resolver.supportsParameter(parameter));
            if (supportedByNonPayloadResolver) continue;
            return this.extractClass(parameter.getGenericParameterType());
        }
        return null;
    }

    private @Nullable Class<?> extractClass(Type type) {
        ResolvableType resolvableType = ResolvableType.forType((Type)type);
        Class rawClass = resolvableType.toClass();
        if (Collection.class.isAssignableFrom(rawClass)) {
            Class elementClass = resolvableType.getNested(2).toClass();
            if (Message.class.isAssignableFrom(elementClass)) {
                return resolvableType.getNested(3).toClass();
            }
            return elementClass;
        }
        if (Message.class.isAssignableFrom(rawClass)) {
            return resolvableType.getNested(2).toClass();
        }
        return rawClass;
    }

    private boolean isPayloadResolver(HandlerMethodArgumentResolver resolver) {
        return resolver instanceof PayloadMethodArgumentResolver || resolver instanceof BatchPayloadMethodArgumentResolver || resolver instanceof MessageMethodArgumentResolver;
    }
}

