/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.annotation;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.DefaultMessageConverterConfiguration;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.EndpointRegistrar;
import io.awspring.cloud.sqs.config.HandlerMethodEndpoint;
import io.awspring.cloud.sqs.config.SqsListenerConfigurer;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.support.converter.legacy.JacksonMessageConverterMigration;
import io.awspring.cloud.sqs.support.resolver.AcknowledgmentHandlerMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchAcknowledgmentArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchPayloadMethodArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractListenerAnnotationBeanPostProcessor<A extends Annotation>
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton {
    private final AtomicInteger counter = new AtomicInteger();
    private final Collection<Class<?>> nonAnnotatedClasses = Collections.synchronizedSet(new HashSet());
    private final EndpointRegistrar endpointRegistrar = this.createEndpointRegistrar();
    private final DelegatingMessageHandlerMethodFactory delegatingHandlerMethodFactory = new DelegatingMessageHandlerMethodFactory();
    private BeanFactory beanFactory;
    private @Nullable BeanExpressionResolver expressionResolver;
    private @Nullable BeanExpressionContext expressionContext;
    private final List<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.nonAnnotatedClasses.contains(targetClass)) {
            return bean;
        }
        this.detectAnnotationsAndRegisterEndpoints(bean, targetClass);
        return bean;
    }

    protected EndpointRegistrar createEndpointRegistrar() {
        return new EndpointRegistrar();
    }

    protected @Nullable ConfigurableBeanFactory getConfigurableBeanFactory() {
        return this.beanFactory instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)this.beanFactory : null;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void detectAnnotationsAndRegisterEndpoints(Object bean, Class<?> targetClass) {
        boolean hasClassLevelListeners;
        Map annotatedMethods = MethodIntrospector.selectMethods(targetClass, method -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.getAnnotationClass()));
        Annotation classListener = AnnotatedElementUtils.findMergedAnnotation(targetClass, this.getAnnotationClass());
        boolean hasMethodLevelListeners = !annotatedMethods.isEmpty();
        boolean bl = hasClassLevelListeners = classListener != null;
        if (!hasMethodLevelListeners && !hasClassLevelListeners) {
            this.nonAnnotatedClasses.add(targetClass);
        } else {
            if (hasMethodLevelListeners) {
                annotatedMethods.entrySet().stream().map(entry -> this.createAndConfigureEndpoint(bean, (Method)entry.getKey(), (Annotation)entry.getValue())).forEach(this.endpointRegistrar::registerEndpoint);
            }
            if (hasClassLevelListeners) {
                Set<Method> handlerMethods = this.getHandlerMethods(targetClass);
                this.createAndConfigureMultiMethodEndpoint(bean, targetClass, classListener, new ArrayList<Method>(handlerMethods));
            }
        }
    }

    protected abstract Class<A> getAnnotationClass();

    protected abstract Set<Method> getHandlerMethods(Class<?> var1);

    private Endpoint createAndConfigureEndpoint(Object bean, Method method, A annotation) {
        Endpoint endpoint = this.createEndpoint(annotation);
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, HandlerMethodEndpoint.class, hme -> {
            hme.setBean(bean);
            hme.setMethod(method);
            hme.setHandlerMethodFactory(this.delegatingHandlerMethodFactory);
            hme.setArgumentResolvers(this.argumentResolvers);
        });
        return endpoint;
    }

    private void createAndConfigureMultiMethodEndpoint(Object bean, Class<?> targetClass, A classListener, List<Method> handlerMethods) {
        Assert.notEmpty(handlerMethods, (String)("No handler method found for listener in class: " + targetClass));
        Method defaultMethod = this.getDefaultHandlerMethod(targetClass, handlerMethods);
        Endpoint endpoint = this.createMultiMethodEndpoint(classListener, handlerMethods, defaultMethod, bean);
        for (Method method : handlerMethods) {
            ConfigUtils.INSTANCE.acceptIfInstance(endpoint, HandlerMethodEndpoint.class, hme -> {
                hme.setBean(bean);
                hme.setMethod(method);
                hme.setHandlerMethodFactory(this.delegatingHandlerMethodFactory);
            });
        }
        this.endpointRegistrar.registerEndpoint(endpoint);
    }

    protected abstract Method getDefaultHandlerMethod(Class<?> var1, List<Method> var2);

    protected abstract Endpoint createEndpoint(A var1);

    protected abstract Endpoint createMultiMethodEndpoint(A var1, List<Method> var2, @Nullable Method var3, Object var4);

    protected Collection<String> resolveEndpointNames(String[] endpointNames) {
        return Arrays.stream(endpointNames).map(this::resolveExpression).flatMap(resolvedName -> this.resolveAsStrings(resolvedName).stream()).collect(Collectors.toList());
    }

    private @Nullable Object resolveExpression(String value) {
        return this.getExpressionResolver() != null ? this.getExpressionResolver().evaluate(this.resolve(value), this.getExpressionContext()) : value;
    }

    protected @Nullable BeanExpressionResolver getExpressionResolver() {
        BeanFactory beanFactory;
        if (this.expressionResolver == null && (beanFactory = this.beanFactory) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
            this.expressionResolver = clbf.getBeanExpressionResolver();
        }
        return this.expressionResolver;
    }

    private @Nullable BeanExpressionContext getExpressionContext() {
        BeanFactory beanFactory;
        if (this.expressionContext == null && (beanFactory = this.beanFactory) instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory clbf = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(clbf, null);
        }
        return this.expressionContext;
    }

    private @Nullable String resolve(String value) {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            return cbf.resolveEmbeddedValue(value);
        }
        return value;
    }

    protected String resolveAsString(String value, String propertyName) {
        try {
            Collection<String> resolvedStrings = this.resolveAsStrings(this.resolve(value));
            return resolvedStrings.isEmpty() ? value : resolvedStrings.iterator().next();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not resolve property " + propertyName, e);
        }
    }

    private Collection<String> resolveAsStrings(@Nullable Object resolvedValue) {
        if (resolvedValue instanceof String[]) {
            String[] strArr = (String[])resolvedValue;
            return this.resolveFromStream(Arrays.stream(strArr));
        }
        if (resolvedValue instanceof Iterable) {
            Iterable itr = (Iterable)resolvedValue;
            return this.resolveFromStream(StreamSupport.stream(itr.spliterator(), false));
        }
        if (resolvedValue instanceof String) {
            String str = (String)resolvedValue;
            return Collections.singletonList(str);
        }
        throw new IllegalArgumentException("Cannot resolve " + resolvedValue + " as String");
    }

    private List<String> resolveFromStream(Stream<?> stream) {
        return stream.flatMap(str -> this.resolveAsStrings(str).stream()).collect(Collectors.toList());
    }

    protected @Nullable Integer resolveAsInteger(String value, String propertyName) {
        try {
            Integer n;
            Object resolvedValue = this.resolveExpression(value);
            if (resolvedValue instanceof Number) {
                Number numberValue = (Number)resolvedValue;
                n = numberValue.intValue();
            } else {
                String stringValue;
                n = resolvedValue instanceof String && StringUtils.hasText((String)(stringValue = (String)resolvedValue)) ? Integer.valueOf(Integer.parseInt(stringValue)) : null;
            }
            return n;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot resolve " + propertyName + " as Integer");
        }
    }

    protected @Nullable AcknowledgementMode resolveAcknowledgement(String value) {
        try {
            String resolvedValue = this.resolveAsString(value, "acknowledgementMode");
            return StringUtils.hasText((String)resolvedValue) ? AcknowledgementMode.valueOf(resolvedValue) : null;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot resolve " + value + " as AcknowledgementMode", e);
        }
    }

    protected String getEndpointId(String id) {
        if (StringUtils.hasText((String)id)) {
            return this.resolveAsString(id, "id");
        }
        return this.getGeneratedIdPrefix() + this.counter.getAndIncrement();
    }

    protected abstract String getGeneratedIdPrefix();

    public void afterSingletonsInstantiated() {
        this.endpointRegistrar.setMessageListenerContainerRegistryBeanName(this.getMessageListenerContainerRegistryBeanName());
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            lbf.getBeansOfType(SqsListenerConfigurer.class).values().forEach(customizer -> customizer.configure(this.endpointRegistrar));
        }
        this.endpointRegistrar.setBeanFactory(this.getBeanFactory());
        this.initializeHandlerMethodFactory();
        this.endpointRegistrar.afterSingletonsInstantiated();
    }

    protected abstract String getMessageListenerContainerRegistryBeanName();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected void initializeHandlerMethodFactory() {
        MessageHandlerMethodFactory handlerMethodFactory = this.endpointRegistrar.getMessageHandlerMethodFactory();
        ConfigUtils.INSTANCE.acceptIfInstance(handlerMethodFactory, DefaultMessageHandlerMethodFactory.class, this::configureDefaultHandlerMethodFactory);
        this.delegatingHandlerMethodFactory.setDelegate(handlerMethodFactory);
    }

    protected void configureDefaultHandlerMethodFactory(DefaultMessageHandlerMethodFactory handlerMethodFactory) {
        CompositeMessageConverter compositeMessageConverter = this.createCompositeMessageConverter();
        ArrayList<HandlerMethodArgumentResolver> methodArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(this.createAdditionalArgumentResolvers((MessageConverter)compositeMessageConverter, this.endpointRegistrar.getJacksonMessageConverterMigration()));
        methodArgumentResolvers.addAll(this.createArgumentResolvers((MessageConverter)compositeMessageConverter));
        this.endpointRegistrar.getMethodArgumentResolversConsumer().accept(methodArgumentResolvers);
        handlerMethodFactory.setArgumentResolvers(methodArgumentResolvers);
        handlerMethodFactory.afterPropertiesSet();
        this.argumentResolvers.addAll(methodArgumentResolvers);
    }

    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers(MessageConverter messageConverter, @Nullable JacksonMessageConverterMigration wrapper) {
        return this.createAdditionalArgumentResolvers();
    }

    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers() {
        return Collections.emptyList();
    }

    protected CompositeMessageConverter createCompositeMessageConverter() {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new StringMessageConverter());
        messageConverters.add(new SimpleMessageConverter());
        if (this.endpointRegistrar.getJacksonMessageConverterMigration() != null) {
            messageConverters.add(this.endpointRegistrar.getJacksonMessageConverterMigration().createMigrationMessageConverter());
        } else {
            messageConverters.add(DefaultMessageConverterConfiguration.createDefaultMessageConverter());
        }
        this.endpointRegistrar.getMessageConverterConsumer().accept(messageConverters);
        return new CompositeMessageConverter(messageConverters);
    }

    protected List<HandlerMethodArgumentResolver> createArgumentResolvers(MessageConverter messageConverter) {
        return Arrays.asList(new AcknowledgmentHandlerMethodArgumentResolver(), new BatchAcknowledgmentArgumentResolver(), new HeaderMethodArgumentResolver((ConversionService)new DefaultConversionService(), this.getConfigurableBeanFactory()), new HeadersMethodArgumentResolver(), new BatchPayloadMethodArgumentResolver(messageConverter, this.endpointRegistrar.getValidator()), new MessageMethodArgumentResolver(messageConverter), new PayloadMethodArgumentResolver(messageConverter, this.endpointRegistrar.getValidator()));
    }

    private static class DelegatingMessageHandlerMethodFactory
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory delegate;

        private DelegatingMessageHandlerMethodFactory() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            Assert.notNull((Object)this.delegate, (String)"No delegate MessageHandlerMethodFactory set.");
            return this.delegate.createInvocableHandlerMethod(bean, method);
        }

        public void setDelegate(MessageHandlerMethodFactory delegate) {
            this.delegate = delegate;
        }
    }
}

