/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.annotation.SnsNotificationSubject;
import io.awspring.cloud.sqs.support.converter.SnsSubjectConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.json.JsonMapper;

public class NotificationSubjectArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(NotificationSubjectArgumentResolver.class);
    private final MessageConverter converter;

    public NotificationSubjectArgumentResolver(JsonMapper jsonMapper) {
        this.converter = new SnsSubjectConverter(jsonMapper);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(SnsNotificationSubject.class)) {
            if (ClassUtils.isAssignable((Class)parameter.getParameterType(), String.class)) {
                return true;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Notification subject can only be injected into String assignable Types - No injection happening for {}#{}", (Object)parameter.getDeclaringClass().getName(), (Object)this.getMethodName(parameter));
            }
        }
        return false;
    }

    public Object resolveArgument(MethodParameter par, Message<?> msg) {
        return this.converter.fromMessage(msg, par.getParameterType());
    }

    private String getMethodName(MethodParameter parameter) {
        Method method = parameter.getMethod();
        Constructor constructor = parameter.getConstructor();
        return Optional.ofNullable(method != null ? method : constructor).map(Executable::getName).orElse("<Method name not resolvable>");
    }
}

