/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.sink.adapter;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.SqsAsyncClientAware;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.sink.MessageSink;
import io.awspring.cloud.sqs.listener.sink.adapter.AbstractDelegatingMessageListeningSinkAdapter;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;

public class MessageVisibilityExtendingSinkAdapter<T>
extends AbstractDelegatingMessageListeningSinkAdapter<T>
implements SqsAsyncClientAware {
    private static final Logger logger = LoggerFactory.getLogger(MessageVisibilityExtendingSinkAdapter.class);
    private static final Duration DEFAULT_VISIBILITY_TO_SET = Duration.ofSeconds(30L);
    private int messageVisibility = (int)DEFAULT_VISIBILITY_TO_SET.getSeconds();
    private SqsAsyncClient sqsAsyncClient;

    public MessageVisibilityExtendingSinkAdapter(MessageSink<T> delegate) {
        super(delegate);
    }

    public void setMessageVisibility(Duration messageVisibility) {
        Assert.notNull((Object)messageVisibility, (String)"visibilityDuration cannot be null");
        this.messageVisibility = (int)messageVisibility.getSeconds();
    }

    @Override
    public void setSqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
        Assert.notNull((Object)sqsAsyncClient, (String)"sqsAsyncClient cannot be null");
        super.setSqsAsyncClient(sqsAsyncClient);
        this.sqsAsyncClient = sqsAsyncClient;
    }

    @Override
    public CompletableFuture<Void> emit(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
        logger.trace("Adding visibility interceptor for messages {}", (Object)MessageHeaderUtils.getId(messages));
        return this.getDelegate().emit(messages, context.addInterceptor(new OriginalBatchMessageVisibilityExtendingInterceptor(messages)));
    }

    private CompletableFuture<Collection<Message<T>>> changeVisibility(Collection<Message<T>> messages) {
        logger.trace("Changing visibility of messages {} to {} seconds", (Object)MessageHeaderUtils.getId(messages), (Object)this.messageVisibility);
        return ((CompletableFuture)this.sqsAsyncClient.changeMessageVisibilityBatch(req -> req.entries(this.getEntries(messages)).queueUrl(this.getQueueUrl(messages)).build()).whenComplete((v, t) -> this.logResult(messages, (Throwable)t))).thenApply(theVoid -> messages);
    }

    private String getQueueUrl(Collection<Message<T>> messages) {
        return (String)messages.iterator().next().getHeaders().get((Object)"Sqs_QueueUrl", String.class);
    }

    private Collection<ChangeMessageVisibilityBatchRequestEntry> getEntries(Collection<Message<T>> messages) {
        return MessageHeaderUtils.getHeader(messages, "Sqs_ReceiptHandle", String.class).stream().map(handle -> (ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().receiptHandle(handle).id(UUID.randomUUID().toString()).visibilityTimeout(Integer.valueOf(this.messageVisibility)).build()).collect(Collectors.toList());
    }

    private void logResult(Collection<Message<T>> messages, Throwable t) {
        if (t == null) {
            logger.trace("Finished changing visibility for messages {}", (Object)MessageHeaderUtils.getId(messages));
        } else {
            logger.error("Error changing visibility for messages {}", (Object)MessageHeaderUtils.getId(messages));
        }
    }

    private class OriginalBatchMessageVisibilityExtendingInterceptor
    implements AsyncMessageInterceptor<T> {
        private final Map<String, Message<T>> originalMessageBatchMap;
        private final int initialBatchSize;

        private OriginalBatchMessageVisibilityExtendingInterceptor(Collection<Message<T>> originalMessageBatch) {
            this.initialBatchSize = originalMessageBatch.size();
            this.originalMessageBatchMap = Collections.synchronizedMap(originalMessageBatch.stream().collect(Collectors.toMap(MessageHeaderUtils::getId, message -> message)));
        }

        @Override
        public CompletableFuture<Message<T>> intercept(Message<T> message) {
            if (this.originalMessageBatchMap.size() == this.initialBatchSize) {
                return CompletableFuture.completedFuture(message);
            }
            return MessageVisibilityExtendingSinkAdapter.this.changeVisibility(this.originalMessageBatchMap.values()).thenApply(response -> message);
        }

        @Override
        public CompletableFuture<Collection<Message<T>>> intercept(Collection<Message<T>> messages) {
            if (this.originalMessageBatchMap.size() == this.initialBatchSize) {
                return CompletableFuture.completedFuture(messages);
            }
            return MessageVisibilityExtendingSinkAdapter.this.changeVisibility(this.originalMessageBatchMap.values()).thenApply(response -> messages);
        }

        @Override
        public CompletableFuture<Void> afterProcessing(Collection<Message<T>> messages, Throwable t) {
            messages.forEach(message -> this.originalMessageBatchMap.remove(MessageHeaderUtils.getId(message)));
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> afterProcessing(Message<T> message, Throwable t) {
            this.originalMessageBatchMap.remove(MessageHeaderUtils.getId(message));
            return CompletableFuture.completedFuture(null);
        }
    }
}

