/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.errorhandler;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.BatchVisibility;
import io.awspring.cloud.sqs.listener.Visibility;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandlerVisibilityHelper;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class LinearBackoffErrorHandler<T>
implements AsyncErrorHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(LinearBackoffErrorHandler.class);
    private final int initialVisibilityTimeoutSeconds;
    private final int increment;
    private final int maxVisibilityTimeoutSeconds;

    private LinearBackoffErrorHandler(int initialVisibilityTimeoutSeconds, int increment, int maxVisibilityTimeoutSeconds) {
        this.initialVisibilityTimeoutSeconds = initialVisibilityTimeoutSeconds;
        this.increment = increment;
        this.maxVisibilityTimeoutSeconds = maxVisibilityTimeoutSeconds;
    }

    @Override
    public CompletableFuture<Void> handle(Message<T> message, Throwable t) {
        return this.applyLinearBackoffVisibilityTimeout(message).thenCompose(theVoid -> CompletableFuture.failedFuture(t));
    }

    @Override
    public CompletableFuture<Void> handle(Collection<Message<T>> messages, Throwable t) {
        return this.applyLinearBackoffVisibilityTimeout(messages).thenCompose(theVoid -> CompletableFuture.failedFuture(t));
    }

    private CompletableFuture<Void> applyLinearBackoffVisibilityTimeout(Collection<Message<T>> messages) {
        CompletableFuture[] futures = (CompletableFuture[])ErrorHandlerVisibilityHelper.groupMessagesByReceiveMessageCount(messages).entrySet().stream().map(entry -> {
            int timeout = this.calculateTimeout((Long)entry.getKey());
            return this.applyBatchVisibilityChange((Collection)entry.getValue(), timeout);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<Void> applyBatchVisibilityChange(Collection<Message<T>> messages, int timeout) {
        logger.debug("Changing batch visibility timeout to {} - Messages Id {}", (Object)timeout, (Object)MessageHeaderUtils.getId(messages));
        BatchVisibility visibility = ErrorHandlerVisibilityHelper.getVisibility(messages);
        return visibility.changeToAsync(timeout).exceptionallyCompose(throwable -> {
            logger.warn("Failed to change batch visibility timeout to {} - Messages Id {}", new Object[]{timeout, MessageHeaderUtils.getId(messages), throwable});
            return CompletableFuture.failedFuture(throwable);
        });
    }

    private CompletableFuture<Void> applyLinearBackoffVisibilityTimeout(Message<T> message) {
        int timeout = this.calculateTimeout(message);
        Visibility visibility = ErrorHandlerVisibilityHelper.getVisibility(message);
        logger.debug("Changing visibility timeout to {} - Message Id {}", (Object)timeout, (Object)message.getHeaders().getId());
        return visibility.changeToAsync(timeout).exceptionallyCompose(throwable -> {
            logger.warn("Failed to change visibility timeout to {} - Message Id {}", new Object[]{timeout, message.getHeaders().getId(), throwable});
            return CompletableFuture.failedFuture(throwable);
        });
    }

    private int calculateTimeout(Message<T> message) {
        long receiveMessageCount = ErrorHandlerVisibilityHelper.getReceiveMessageCount(message);
        return this.calculateTimeout(receiveMessageCount);
    }

    private int calculateTimeout(long receiveMessageCount) {
        return ErrorHandlerVisibilityHelper.calculateVisibilityTimeoutLinearly(receiveMessageCount, this.initialVisibilityTimeoutSeconds, this.increment, this.maxVisibilityTimeoutSeconds);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private int initialVisibilityTimeoutSeconds = 100;
        private int increment = 2;
        private int maxVisibilityTimeoutSeconds = 43200;

        public Builder<T> initialVisibilityTimeoutSeconds(int initialVisibilityTimeoutSeconds) {
            ErrorHandlerVisibilityHelper.checkVisibilityTimeout(initialVisibilityTimeoutSeconds);
            this.initialVisibilityTimeoutSeconds = initialVisibilityTimeoutSeconds;
            return this;
        }

        public Builder<T> increment(int increment) {
            Assert.isTrue((increment >= 1 ? 1 : 0) != 0, () -> "Invalid increment '" + increment + "'. Should be greater than or equal to 1.");
            this.increment = increment;
            return this;
        }

        public Builder<T> maxVisibilityTimeoutSeconds(int maxVisibilityTimeoutSeconds) {
            ErrorHandlerVisibilityHelper.checkVisibilityTimeout(maxVisibilityTimeoutSeconds);
            this.maxVisibilityTimeoutSeconds = maxVisibilityTimeoutSeconds;
            return this;
        }

        public LinearBackoffErrorHandler<T> build() {
            Assert.isTrue((this.initialVisibilityTimeoutSeconds <= this.maxVisibilityTimeoutSeconds ? 1 : 0) != 0, (String)"Initial visibility timeout must not exceed max visibility timeout");
            return new LinearBackoffErrorHandler(this.initialVisibilityTimeoutSeconds, this.increment, this.maxVisibilityTimeoutSeconds);
        }
    }
}

