/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.config.AbstractMessageListenerContainerFactory;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.MultiMethodSqsEndpoint;
import io.awspring.cloud.sqs.config.SqsEndpoint;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.ContainerComponentFactory;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.SqsContainerOptions;
import io.awspring.cloud.sqs.listener.SqsContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.SqsMessageListenerContainer;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.AsyncAcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public class SqsMessageListenerContainerFactory<T>
extends AbstractMessageListenerContainerFactory<T, SqsMessageListenerContainer<T>, SqsContainerOptions, SqsContainerOptionsBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(SqsMessageListenerContainerFactory.class);
    private Supplier<SqsAsyncClient> sqsAsyncClientSupplier;

    public SqsMessageListenerContainerFactory() {
        super((SqsContainerOptions)SqsContainerOptions.builder().build());
    }

    @Override
    protected SqsMessageListenerContainer<T> createContainerInstance(Endpoint endpoint, SqsContainerOptions containerOptions) {
        logger.debug("Creating {} for endpoint {}", (Object)SqsMessageListenerContainer.class.getSimpleName(), endpoint.getId() != null ? endpoint.getId() : endpoint.getLogicalNames());
        Assert.notNull(this.sqsAsyncClientSupplier, (String)"asyncClientSupplier not set");
        SqsAsyncClient asyncClient = this.getSqsAsyncClientInstance();
        return new SqsMessageListenerContainer(asyncClient, containerOptions);
    }

    protected SqsAsyncClient getSqsAsyncClientInstance() {
        return this.sqsAsyncClientSupplier.get();
    }

    @Override
    protected void configureContainerOptions(Endpoint endpoint, SqsContainerOptionsBuilder options) {
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, SqsEndpoint.class, sqsEndpoint -> this.configureFromSqsEndpoint((SqsEndpoint)sqsEndpoint, options));
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, MultiMethodSqsEndpoint.class, multiMethodSqsEndpoint -> this.configureFromMultiMethodSqsEndpoint((MultiMethodSqsEndpoint)multiMethodSqsEndpoint, options));
    }

    private void configureFromMultiMethodSqsEndpoint(MultiMethodSqsEndpoint multiMethodSqsEndpoint, SqsContainerOptionsBuilder options) {
        ConfigUtils.INSTANCE.acceptIfInstance(multiMethodSqsEndpoint.getEndpoint(), SqsEndpoint.class, endpoint -> this.configureFromSqsEndpoint((SqsEndpoint)endpoint, options));
    }

    private void configureFromSqsEndpoint(SqsEndpoint sqsEndpoint, SqsContainerOptionsBuilder options) {
        ConfigUtils.INSTANCE.acceptIfNotNull(sqsEndpoint.getMaxConcurrentMessages(), options::maxConcurrentMessages).acceptIfNotNull(sqsEndpoint.getMaxMessagesPerPoll(), options::maxMessagesPerPoll).acceptIfNotNull(sqsEndpoint.getPollTimeout(), options::pollTimeout).acceptIfNotNull(sqsEndpoint.getMessageVisibility(), options::messageVisibility).acceptIfNotNull(sqsEndpoint.getAcknowledgementMode(), options::acknowledgementMode);
    }

    public void setSqsAsyncClientSupplier(Supplier<SqsAsyncClient> sqsAsyncClientSupplier) {
        Assert.notNull(sqsAsyncClientSupplier, (String)"sqsAsyncClientSupplier cannot be null.");
        this.sqsAsyncClientSupplier = sqsAsyncClientSupplier;
    }

    public void setSqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
        Assert.notNull((Object)sqsAsyncClient, (String)"sqsAsyncClient cannot be null.");
        this.setSqsAsyncClientSupplier(() -> sqsAsyncClient);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final Collection<AsyncMessageInterceptor<T>> asyncMessageInterceptors = new ArrayList<AsyncMessageInterceptor<T>>();
        private final Collection<MessageInterceptor<T>> messageInterceptors = new ArrayList<MessageInterceptor<T>>();
        private Supplier<SqsAsyncClient> sqsAsyncClientSupplier;
        private SqsAsyncClient sqsAsyncClient;
        private Collection<ContainerComponentFactory<T, SqsContainerOptions>> containerComponentFactories;
        private AsyncMessageListener<T> asyncMessageListener;
        private MessageListener<T> messageListener;
        private AsyncErrorHandler<T> asyncErrorHandler;
        private ErrorHandler<T> errorHandler;
        private Consumer<SqsContainerOptionsBuilder> optionsConsumer = options -> {};
        private AcknowledgementResultCallback<T> acknowledgementResultCallback;
        private AsyncAcknowledgementResultCallback<T> asyncAcknowledgementResultCallback;

        public Builder<T> sqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
            this.sqsAsyncClient = sqsAsyncClient;
            return this;
        }

        public Builder<T> sqsAsyncClientSupplier(Supplier<SqsAsyncClient> sqsAsyncClientSupplier) {
            this.sqsAsyncClientSupplier = sqsAsyncClientSupplier;
            return this;
        }

        public Builder<T> containerComponentFactories(Collection<ContainerComponentFactory<T, SqsContainerOptions>> containerComponentFactories) {
            this.containerComponentFactories = containerComponentFactories;
            return this;
        }

        public Builder<T> asyncMessageListener(AsyncMessageListener<T> asyncMessageListener) {
            this.asyncMessageListener = asyncMessageListener;
            return this;
        }

        public Builder<T> messageListener(MessageListener<T> messageListener) {
            this.messageListener = messageListener;
            return this;
        }

        public Builder<T> errorHandler(AsyncErrorHandler<T> asyncErrorHandler) {
            this.asyncErrorHandler = asyncErrorHandler;
            return this;
        }

        public Builder<T> errorHandler(ErrorHandler<T> errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder<T> messageInterceptor(AsyncMessageInterceptor<T> asyncMessageInterceptor) {
            this.asyncMessageInterceptors.add(asyncMessageInterceptor);
            return this;
        }

        public Builder<T> messageInterceptor(MessageInterceptor<T> messageInterceptor) {
            this.messageInterceptors.add(messageInterceptor);
            return this;
        }

        public Builder<T> acknowledgementResultCallback(AsyncAcknowledgementResultCallback<T> asyncAcknowledgementResultCallback) {
            this.asyncAcknowledgementResultCallback = asyncAcknowledgementResultCallback;
            return this;
        }

        public Builder<T> acknowledgementResultCallback(AcknowledgementResultCallback<T> acknowledgementResultCallback) {
            this.acknowledgementResultCallback = acknowledgementResultCallback;
            return this;
        }

        public Builder<T> configure(Consumer<SqsContainerOptionsBuilder> options) {
            this.optionsConsumer = options;
            return this;
        }

        public SqsMessageListenerContainerFactory<T> build() {
            SqsMessageListenerContainerFactory factory = new SqsMessageListenerContainerFactory();
            ConfigUtils.INSTANCE.acceptIfNotNull(this.messageListener, factory::setMessageListener).acceptIfNotNull(this.asyncMessageListener, factory::setAsyncMessageListener).acceptIfNotNull(this.errorHandler, factory::setErrorHandler).acceptIfNotNull(this.asyncErrorHandler, factory::setErrorHandler).acceptIfNotNull(this.acknowledgementResultCallback, factory::setAcknowledgementResultCallback).acceptIfNotNull(this.asyncAcknowledgementResultCallback, factory::setAcknowledgementResultCallback).acceptIfNotNull(this.containerComponentFactories, factory::setContainerComponentFactories).acceptIfNotNull(this.sqsAsyncClient, factory::setSqsAsyncClient).acceptIfNotNull(this.sqsAsyncClientSupplier, factory::setSqsAsyncClientSupplier);
            this.messageInterceptors.forEach(factory::addMessageInterceptor);
            this.asyncMessageInterceptors.forEach(factory::addMessageInterceptor);
            factory.configure(this.optionsConsumer);
            return factory;
        }
    }
}

