/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.listener.AbstractPipelineMessageListenerContainer;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.ContainerComponentFactory;
import io.awspring.cloud.sqs.listener.FifoSqsComponentFactory;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.SqsAsyncClientAware;
import io.awspring.cloud.sqs.listener.SqsContainerOptions;
import io.awspring.cloud.sqs.listener.SqsContainerOptionsBuilder;
import io.awspring.cloud.sqs.listener.StandardSqsComponentFactory;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.AsyncAcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import io.awspring.cloud.sqs.listener.sink.MessageSink;
import io.awspring.cloud.sqs.listener.source.MessageSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public class SqsMessageListenerContainer<T>
extends AbstractPipelineMessageListenerContainer<T, SqsContainerOptions, SqsContainerOptionsBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(SqsMessageListenerContainer.class);
    private final SqsAsyncClient sqsAsyncClient;

    public SqsMessageListenerContainer(SqsAsyncClient sqsAsyncClient, SqsContainerOptions options) {
        super(options);
        Assert.notNull((Object)sqsAsyncClient, (String)"sqsAsyncClient cannot be null");
        this.sqsAsyncClient = sqsAsyncClient;
    }

    public SqsMessageListenerContainer(SqsAsyncClient sqsAsyncClient) {
        this(sqsAsyncClient, (SqsContainerOptions)SqsContainerOptions.builder().build());
    }

    @Override
    protected Collection<ContainerComponentFactory<T, SqsContainerOptions>> createDefaultComponentFactories() {
        return Arrays.asList(new FifoSqsComponentFactory(), new StandardSqsComponentFactory());
    }

    @Override
    public void setQueueNames(Collection<String> queueNames) {
        Assert.isTrue((queueNames.stream().allMatch(this::isFifoQueue) || queueNames.stream().noneMatch(this::isFifoQueue) ? 1 : 0) != 0, (String)"SqsMessageListenerContainer must contain either all FIFO or all Standard queues.");
        super.setQueueNames(queueNames);
    }

    private boolean isFifoQueue(String name) {
        return name.endsWith(".fifo");
    }

    @Override
    protected void doConfigureMessageSources(Collection<MessageSource<T>> messageSources) {
        ConfigUtils.INSTANCE.acceptManyIfInstance(messageSources, SqsAsyncClientAware.class, asca -> asca.setSqsAsyncClient(this.sqsAsyncClient));
    }

    @Override
    protected void doConfigureMessageSink(MessageSink<T> messageSink) {
        ConfigUtils.INSTANCE.acceptIfInstance(messageSink, SqsAsyncClientAware.class, asca -> asca.setSqsAsyncClient(this.sqsAsyncClient));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final Collection<String> queueNames = new ArrayList<String>();
        private final Collection<AsyncMessageInterceptor<T>> asyncMessageInterceptors = new ArrayList<AsyncMessageInterceptor<T>>();
        private final Collection<MessageInterceptor<T>> messageInterceptors = new ArrayList<MessageInterceptor<T>>();
        private SqsAsyncClient sqsAsyncClient;
        private Collection<ContainerComponentFactory<T, SqsContainerOptions>> containerComponentFactories;
        private AsyncMessageListener<T> asyncMessageListener;
        private MessageListener<T> messageListener;
        private String id;
        private AsyncErrorHandler<T> asyncErrorHandler;
        private ErrorHandler<T> errorHandler;
        private Consumer<SqsContainerOptionsBuilder> optionsConsumer = options -> {};
        private AsyncAcknowledgementResultCallback<T> asyncAcknowledgementResultCallback;
        private AcknowledgementResultCallback<T> acknowledgementResultCallback;
        private Integer phase;

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> sqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
            this.sqsAsyncClient = sqsAsyncClient;
            return this;
        }

        public Builder<T> queueNames(String ... queueNames) {
            this.queueNames.addAll(Arrays.asList(queueNames));
            return this;
        }

        public Builder<T> queueNames(Collection<String> queueNames) {
            this.queueNames.addAll(queueNames);
            return this;
        }

        public Builder<T> componentFactories(Collection<ContainerComponentFactory<T, SqsContainerOptions>> containerComponentFactories) {
            this.containerComponentFactories = containerComponentFactories;
            return this;
        }

        public Builder<T> asyncMessageListener(AsyncMessageListener<T> asyncMessageListener) {
            this.asyncMessageListener = asyncMessageListener;
            return this;
        }

        public Builder<T> messageListener(MessageListener<T> messageListener) {
            this.messageListener = messageListener;
            return this;
        }

        public Builder<T> errorHandler(AsyncErrorHandler<T> asyncErrorHandler) {
            this.asyncErrorHandler = asyncErrorHandler;
            return this;
        }

        public Builder<T> errorHandler(ErrorHandler<T> errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder<T> messageInterceptor(AsyncMessageInterceptor<T> asyncMessageInterceptor) {
            this.asyncMessageInterceptors.add(asyncMessageInterceptor);
            return this;
        }

        public Builder<T> messageInterceptor(MessageInterceptor<T> messageInterceptor) {
            this.messageInterceptors.add(messageInterceptor);
            return this;
        }

        public Builder<T> acknowledgementResultCallback(AsyncAcknowledgementResultCallback<T> asyncAcknowledgementResultCallback) {
            this.asyncAcknowledgementResultCallback = asyncAcknowledgementResultCallback;
            return this;
        }

        public Builder<T> acknowledgementResultCallback(AcknowledgementResultCallback<T> acknowledgementResultCallback) {
            this.acknowledgementResultCallback = acknowledgementResultCallback;
            return this;
        }

        public Builder<T> configure(Consumer<SqsContainerOptionsBuilder> options) {
            this.optionsConsumer = options;
            return this;
        }

        public Builder<T> phase(Integer phase) {
            this.phase = phase;
            return this;
        }

        public SqsMessageListenerContainer<T> build() {
            SqsMessageListenerContainer container = new SqsMessageListenerContainer(this.sqsAsyncClient);
            ConfigUtils.INSTANCE.acceptIfNotNull(this.id, container::setId).acceptIfNotNull(this.messageListener, container::setMessageListener).acceptIfNotNull(this.asyncMessageListener, container::setAsyncMessageListener).acceptIfNotNull(this.errorHandler, container::setErrorHandler).acceptIfNotNull(this.asyncErrorHandler, container::setErrorHandler).acceptIfNotNull(this.acknowledgementResultCallback, container::setAcknowledgementResultCallback).acceptIfNotNull(this.asyncAcknowledgementResultCallback, container::setAcknowledgementResultCallback).acceptIfNotNull(this.containerComponentFactories, container::setComponentFactories).acceptIfNotEmpty(this.queueNames, container::setQueueNames).acceptIfNotNullOrElse(container::setPhase, this.phase, Integer.MAX_VALUE);
            this.messageInterceptors.forEach(container::addMessageInterceptor);
            this.asyncMessageInterceptors.forEach(container::addMessageInterceptor);
            container.configure(this.optionsConsumer);
            return container;
        }
    }
}

