/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.acknowledgement.Acknowledgement;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import java.util.concurrent.CompletableFuture;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AcknowledgmentHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable(Acknowledgement.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, final Message<?> message) {
        final AcknowledgementCallback callback = (AcknowledgementCallback)message.getHeaders().get((Object)"AcknowledgementCallback", AcknowledgementCallback.class);
        Assert.notNull((Object)callback, (String)("No acknowledgement found for message " + MessageHeaderUtils.getId(message) + ". AcknowledgeMode should be MANUAL."));
        return new Acknowledgement(){

            @Override
            public void acknowledge() {
                this.acknowledgeAsync().join();
            }

            @Override
            public CompletableFuture<Void> acknowledgeAsync() {
                return callback.onAcknowledge(message);
            }
        };
    }
}

