/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.converter;

import io.awspring.cloud.sqs.support.converter.AbstractMessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.HeaderMapper;
import io.awspring.cloud.sqs.support.converter.MessageConversionContext;
import io.awspring.cloud.sqs.support.converter.SqsHeaderMapper;
import io.awspring.cloud.sqs.support.converter.SqsMessageConversionContext;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.sqs.model.Message;

public class SqsMessagingMessageConverter
extends AbstractMessagingMessageConverter<Message> {
    @Override
    protected HeaderMapper<Message> createDefaultHeaderMapper() {
        return new SqsHeaderMapper();
    }

    @Override
    protected Object getPayloadToDeserialize(Message message) {
        return message.body();
    }

    @Override
    public MessageConversionContext createMessageConversionContext() {
        return new SqsMessageConversionContext();
    }

    @Override
    protected Message doConvertMessage(Message messageWithHeaders, Object payload) {
        Assert.isInstanceOf(String.class, (Object)payload, (String)"payload must be instance of String");
        return (Message)messageWithHeaders.toBuilder().body((String)payload).build();
    }
}

