/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementProcessor;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementHandler;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AlwaysAcknowledgementHandler;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.NeverAcknowledgementHandler;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.OnSuccessAcknowledgementHandler;
import io.awspring.cloud.sqs.listener.sink.MessageSink;
import io.awspring.cloud.sqs.listener.source.MessageSource;
import java.util.Collection;

public interface ContainerComponentFactory<T, O extends ContainerOptions<O, ?>> {
    default public boolean supports(Collection<String> queueNames, O options) {
        return true;
    }

    public MessageSource<T> createMessageSource(O var1);

    public MessageSink<T> createMessageSink(O var1);

    default public AcknowledgementProcessor<T> createAcknowledgementProcessor(O options) {
        throw new UnsupportedOperationException("AcknowledgementProcessor support not implemented by this " + ContainerComponentFactory.class.getSimpleName());
    }

    default public AcknowledgementHandler<T> createAcknowledgementHandler(O options) {
        AcknowledgementMode mode = options.getAcknowledgementMode();
        return AcknowledgementMode.ON_SUCCESS.equals((Object)mode) ? new OnSuccessAcknowledgementHandler() : (AcknowledgementMode.ALWAYS.equals((Object)mode) ? new AlwaysAcknowledgementHandler() : new NeverAcknowledgementHandler());
    }
}

