/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.annotation.SnsNotificationMessage;
import io.awspring.cloud.sqs.support.converter.SnsMessageConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;

public class NotificationMessageArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SmartMessageConverter converter;

    public NotificationMessageArgumentResolver(MessageConverter converter, ObjectMapper jsonMapper) {
        this.converter = new SnsMessageConverter(converter, jsonMapper);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(SnsNotificationMessage.class);
    }

    public Object resolveArgument(MethodParameter par, Message<?> msg) {
        Object object = this.converter.fromMessage(msg, par.getParameterType(), (Object)par);
        Assert.isInstanceOf(SnsMessageConverter.SnsMessageWrapper.class, (Object)object);
        SnsMessageConverter.SnsMessageWrapper nr = (SnsMessageConverter.SnsMessageWrapper)object;
        return nr.message();
    }
}

