/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

public class BatchPayloadMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;
    @Nullable
    private final Validator validator;
    private final Map<MethodParameter, Class<?>> targetClassCache = new ConcurrentHashMap();

    public BatchPayloadMethodArgumentResolver(MessageConverter messageConverter) {
        this(messageConverter, null);
    }

    public BatchPayloadMethodArgumentResolver(MessageConverter messageConverter, @Nullable Validator validator) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.converter = messageConverter;
        this.validator = validator;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class parameterClass = ResolvableType.forType((Type)parameter.getGenericParameterType()).toClass();
        return Collection.class.isAssignableFrom(parameterClass);
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) {
        Class<?> targetClass = this.resolveTargetClass(parameter);
        boolean isMessageParameter = Message.class.isAssignableFrom(ResolvableType.forMethodParameter((MethodParameter)parameter).getNested(2).toClass());
        return this.getPayloadAsCollection(message).stream().filter(msg -> Message.class.isAssignableFrom(msg.getClass())).map(Message.class::cast).map(msg -> this.convertAndValidatePayload(parameter, (Message<?>)msg, targetClass, isMessageParameter)).collect(Collectors.toList());
    }

    private Collection<?> getPayloadAsCollection(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof Collection && !((Collection)payload).isEmpty()) {
            return (Collection)payload;
        }
        throw new IllegalArgumentException("Payload must be a non-empty Collection: " + message);
    }

    private Object convertAndValidatePayload(MethodParameter parameter, Message<?> message, Class<?> targetClass, boolean isMessageParameter) {
        Object convertedPayload = this.getConvertedPayload(message, targetClass);
        if (convertedPayload == null) {
            throw new MessageConversionException(message, "Cannot convert from [" + message.getPayload().getClass().getName() + "] to [" + targetClass.getName() + "] for " + message);
        }
        this.validate(message, parameter, convertedPayload);
        return isMessageParameter ? MessageBuilder.createMessage((Object)convertedPayload, (MessageHeaders)message.getHeaders()) : convertedPayload;
    }

    private Object getConvertedPayload(Message<?> message, Class<?> targetClass) {
        return this.converter.fromMessage(message, targetClass);
    }

    private Class<?> resolveTargetClass(MethodParameter parameter) {
        return this.targetClassCache.computeIfAbsent(parameter, param -> {
            ResolvableType resolvableType = ResolvableType.forType((Type)parameter.getGenericParameterType());
            Class<?> collectionGenericClass = this.throwIfObject(resolvableType.getNested(2).toClass(), parameter);
            if (Message.class.isAssignableFrom(collectionGenericClass)) {
                return this.throwIfObject(resolvableType.getNested(3).toClass(), parameter);
            }
            return collectionGenericClass;
        });
    }

    private Class<?> throwIfObject(Class<?> classToCompare, MethodParameter parameter) {
        if (Object.class.equals(classToCompare)) {
            throw new IllegalArgumentException(String.format("Could not resolve target for parameter %s in method %s from class %s. Generic types are required.", parameter.getParameterName(), parameter.getMethod().getName(), parameter.getContainingClass()));
        }
        return classToCompare;
    }

    protected void validate(Message<?> message, MethodParameter parameter, Object target) {
        if (this.validator == null) {
            return;
        }
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(target, this.getParameterName(parameter));
            if (!ObjectUtils.isEmpty((Object[])validationHints) && this.validator instanceof SmartValidator) {
                ((SmartValidator)this.validator).validate(target, (Errors)bindingResult, validationHints);
            } else {
                this.validator.validate(target, (Errors)bindingResult);
            }
            if (!bindingResult.hasErrors()) break;
            throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
        }
    }

    private String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName != null ? paramName : "Arg " + param.getParameterIndex();
    }
}

