/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.annotation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.EndpointRegistrar;
import io.awspring.cloud.sqs.config.HandlerMethodEndpoint;
import io.awspring.cloud.sqs.config.SqsListenerConfigurer;
import io.awspring.cloud.sqs.support.resolver.AcknowledgmentHandlerMethodArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchAcknowledgmentArgumentResolver;
import io.awspring.cloud.sqs.support.resolver.BatchPayloadMethodArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public abstract class AbstractListenerAnnotationBeanPostProcessor<A extends Annotation>
implements BeanPostProcessor,
BeanFactoryAware,
SmartInitializingSingleton,
EmbeddedValueResolverAware {
    private final AtomicInteger counter = new AtomicInteger();
    private final Collection<Class<?>> nonAnnotatedClasses = Collections.synchronizedSet(new HashSet());
    private final EndpointRegistrar endpointRegistrar = this.createEndpointRegistrar();
    private final DelegatingMessageHandlerMethodFactory delegatingHandlerMethodFactory = new DelegatingMessageHandlerMethodFactory();
    private BeanFactory beanFactory;
    private StringValueResolver resolver;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.nonAnnotatedClasses.contains(targetClass)) {
            return bean;
        }
        this.detectAnnotationsAndRegisterEndpoints(bean, targetClass);
        return bean;
    }

    @Nullable
    protected ConfigurableBeanFactory getConfigurableBeanFactory() {
        return this.beanFactory instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)this.beanFactory : null;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void detectAnnotationsAndRegisterEndpoints(Object bean, Class<?> targetClass) {
        Map annotatedMethods = MethodIntrospector.selectMethods(targetClass, method -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.getAnnotationClass()));
        if (annotatedMethods.isEmpty()) {
            this.nonAnnotatedClasses.add(targetClass);
        }
        annotatedMethods.entrySet().stream().map(entry -> this.createAndConfigureEndpoint(bean, (Method)entry.getKey(), (Annotation)entry.getValue())).forEach(this.endpointRegistrar::registerEndpoint);
    }

    protected abstract Class<A> getAnnotationClass();

    private Endpoint createAndConfigureEndpoint(Object bean, Method method, A annotation) {
        Endpoint endpoint = this.createEndpoint(annotation);
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, HandlerMethodEndpoint.class, hme -> {
            hme.setBean(bean);
            hme.setMethod(method);
            hme.setHandlerMethodFactory(this.delegatingHandlerMethodFactory);
        });
        return endpoint;
    }

    protected abstract Endpoint createEndpoint(A var1);

    protected String resolveAsString(String value, String propertyName) {
        try {
            return this.getValueResolver().resolveStringValue(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error resolving property " + propertyName, e);
        }
    }

    protected StringValueResolver getValueResolver() {
        return this.resolver;
    }

    protected Integer resolveAsInteger(String value, String propertyName) {
        String resolvedValue = this.resolveAsString(value, propertyName);
        return StringUtils.hasText((String)resolvedValue) ? Integer.valueOf(Integer.parseInt(resolvedValue)) : null;
    }

    protected Set<String> resolveStringArray(String[] destinationNames, String propertyName) {
        return Arrays.stream(destinationNames).map(destinationName -> this.resolveAsString((String)destinationName, propertyName)).collect(Collectors.toSet());
    }

    protected String getEndpointId(String id) {
        if (StringUtils.hasText((String)id)) {
            return this.resolveAsString(id, "id");
        }
        return this.getGeneratedIdPrefix() + this.counter.getAndIncrement();
    }

    protected abstract String getGeneratedIdPrefix();

    public void afterSingletonsInstantiated() {
        if (this.beanFactory instanceof ListableBeanFactory) {
            ((ListableBeanFactory)this.beanFactory).getBeansOfType(SqsListenerConfigurer.class).values().forEach(customizer -> customizer.configure(this.endpointRegistrar));
        }
        this.endpointRegistrar.setBeanFactory(this.getBeanFactory());
        this.initializeHandlerMethodFactory();
        this.endpointRegistrar.afterSingletonsInstantiated();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected void initializeHandlerMethodFactory() {
        MessageHandlerMethodFactory handlerMethodFactory = this.endpointRegistrar.getMessageHandlerMethodFactory();
        ConfigUtils.INSTANCE.acceptIfInstance(handlerMethodFactory, DefaultMessageHandlerMethodFactory.class, this::configureDefaultHandlerMethodFactory);
        this.delegatingHandlerMethodFactory.setDelegate(handlerMethodFactory);
    }

    protected void configureDefaultHandlerMethodFactory(DefaultMessageHandlerMethodFactory handlerMethodFactory) {
        CompositeMessageConverter compositeMessageConverter = this.createCompositeMessageConverter();
        ArrayList<HandlerMethodArgumentResolver> methodArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(this.createAdditionalArgumentResolvers());
        methodArgumentResolvers.addAll(this.createArgumentResolvers((MessageConverter)compositeMessageConverter));
        this.endpointRegistrar.getMethodArgumentResolversConsumer().accept(methodArgumentResolvers);
        handlerMethodFactory.setArgumentResolvers(methodArgumentResolvers);
        handlerMethodFactory.afterPropertiesSet();
    }

    protected Collection<HandlerMethodArgumentResolver> createAdditionalArgumentResolvers() {
        return Collections.emptyList();
    }

    protected CompositeMessageConverter createCompositeMessageConverter() {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new StringMessageConverter());
        messageConverters.add(new SimpleMessageConverter());
        messageConverters.add(this.createDefaultMappingJackson2MessageConverter(this.endpointRegistrar.getObjectMapper()));
        this.endpointRegistrar.getMessageConverterConsumer().accept(messageConverters);
        return new CompositeMessageConverter(messageConverters);
    }

    protected List<HandlerMethodArgumentResolver> createArgumentResolvers(MessageConverter messageConverter) {
        return Arrays.asList(new AcknowledgmentHandlerMethodArgumentResolver(), new BatchAcknowledgmentArgumentResolver(), new HeaderMethodArgumentResolver((ConversionService)new DefaultConversionService(), this.getConfigurableBeanFactory()), new HeadersMethodArgumentResolver(), new BatchPayloadMethodArgumentResolver(messageConverter), new MessageMethodArgumentResolver(messageConverter), new PayloadMethodArgumentResolver(messageConverter));
    }

    protected MappingJackson2MessageConverter createDefaultMappingJackson2MessageConverter(ObjectMapper objectMapper) {
        MappingJackson2MessageConverter jacksonMessageConverter = new MappingJackson2MessageConverter();
        jacksonMessageConverter.setSerializedPayloadClass(String.class);
        jacksonMessageConverter.setStrictContentTypeMatch(false);
        if (objectMapper != null) {
            jacksonMessageConverter.setObjectMapper(objectMapper);
        }
        return jacksonMessageConverter;
    }

    protected EndpointRegistrar createEndpointRegistrar() {
        return new EndpointRegistrar();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    private static class DelegatingMessageHandlerMethodFactory
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory delegate;

        private DelegatingMessageHandlerMethodFactory() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            Assert.notNull((Object)this.delegate, (String)"No delegate MessageHandlerMethodFactory set.");
            return this.delegate.createInvocableHandlerMethod(bean, method);
        }

        public void setDelegate(MessageHandlerMethodFactory delegate) {
            this.delegate = delegate;
        }
    }
}

