/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.BackPressureMode;
import io.awspring.cloud.sqs.listener.BatchAwareBackPressureHandler;
import io.awspring.cloud.sqs.listener.IdentifiableContainerComponent;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SemaphoreBackPressureHandler
implements BatchAwareBackPressureHandler,
IdentifiableContainerComponent {
    private static final Logger logger = LoggerFactory.getLogger(SemaphoreBackPressureHandler.class);
    private final Semaphore semaphore;
    private final int batchSize;
    private final int totalPermits;
    private final Duration acquireTimeout;
    private final BackPressureMode backPressureConfiguration;
    private volatile CurrentThroughputMode currentThroughputMode;
    private final AtomicBoolean hasAcquiredFullPermits = new AtomicBoolean(false);
    private String id;

    private SemaphoreBackPressureHandler(Builder builder) {
        this.batchSize = builder.batchSize;
        this.totalPermits = builder.totalPermits;
        this.acquireTimeout = builder.acquireTimeout;
        this.backPressureConfiguration = builder.backPressureMode;
        this.semaphore = new Semaphore(this.totalPermits);
        this.currentThroughputMode = BackPressureMode.FIXED_HIGH_THROUGHPUT.equals((Object)this.backPressureConfiguration) ? CurrentThroughputMode.HIGH : CurrentThroughputMode.LOW;
        logger.debug("SemaphoreBackPressureHandler created with configuration {} and {} total permits", (Object)this.backPressureConfiguration, (Object)this.totalPermits);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int request(int amount) throws InterruptedException {
        return this.tryAcquire(amount) ? amount : 0;
    }

    @Override
    public int requestBatch() throws InterruptedException {
        return CurrentThroughputMode.LOW.equals((Object)this.currentThroughputMode) ? this.requestInLowThroughputMode() : this.requestInHighThroughputMode();
    }

    private int requestInHighThroughputMode() throws InterruptedException {
        return this.tryAcquire(this.batchSize) ? this.batchSize : this.tryAcquirePartial();
    }

    private int tryAcquirePartial() throws InterruptedException {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0 || BackPressureMode.ALWAYS_POLL_MAX_MESSAGES.equals((Object)this.backPressureConfiguration)) {
            return 0;
        }
        int permitsToRequest = Math.min(availablePermits, this.batchSize);
        logger.trace("Trying to acquire partial batch of {} permits from {} available for {} in TM {}", new Object[]{permitsToRequest, availablePermits, this.id, this.currentThroughputMode});
        boolean hasAcquiredPartial = this.tryAcquire(permitsToRequest);
        return hasAcquiredPartial ? permitsToRequest : 0;
    }

    private int requestInLowThroughputMode() throws InterruptedException {
        logger.debug("Trying to acquire full permits for {}. Permits left: {}", (Object)this.id, (Object)this.semaphore.availablePermits());
        boolean hasAcquired = this.tryAcquire(this.totalPermits);
        if (hasAcquired) {
            logger.debug("Acquired full permits for {}. Permits left: {}", (Object)this.id, (Object)this.semaphore.availablePermits());
            if (!this.hasAcquiredFullPermits.compareAndSet(false, true)) {
                logger.warn("hasAcquiredFullPermits was already true");
            }
            return this.batchSize;
        }
        return 0;
    }

    private boolean tryAcquire(int amount) throws InterruptedException {
        logger.trace("Acquiring {} permits for {} in TM {}", new Object[]{amount, this.id, this.currentThroughputMode});
        boolean hasAcquired = this.semaphore.tryAcquire(amount, this.acquireTimeout.getSeconds(), TimeUnit.SECONDS);
        if (hasAcquired) {
            logger.trace("{} permits acquired for {} in TM {}. Permits left: {}", new Object[]{amount, this.id, this.currentThroughputMode, this.semaphore.availablePermits()});
        } else {
            logger.trace("Not able to acquire {} permits in {} seconds for {} in TM {}. Permits left: {}", new Object[]{amount, this.acquireTimeout.getSeconds(), this.id, this.currentThroughputMode, this.semaphore.availablePermits()});
        }
        return hasAcquired;
    }

    @Override
    public void releaseBatch() {
        this.maybeSwitchToLowThroughputMode();
        int permitsToRelease = this.getPermitsToRelease(this.batchSize);
        this.semaphore.release(permitsToRelease);
        logger.trace("Released {} permits for {}. Permits left: {}", new Object[]{permitsToRelease, this.id, this.semaphore.availablePermits()});
    }

    private void maybeSwitchToLowThroughputMode() {
        if (!BackPressureMode.FIXED_HIGH_THROUGHPUT.equals((Object)this.backPressureConfiguration) && CurrentThroughputMode.HIGH.equals((Object)this.currentThroughputMode)) {
            logger.debug("Entire batch of permits released for {}, setting low throughput mode. Permits left: {}", (Object)this.id, (Object)this.semaphore.availablePermits());
            this.currentThroughputMode = CurrentThroughputMode.LOW;
        }
    }

    @Override
    public void release(int amount) {
        this.maybeSwitchToHighThroughputMode(amount);
        int permitsToRelease = this.getPermitsToRelease(amount);
        this.semaphore.release(permitsToRelease);
        logger.trace("Released {} permits for {}. Permits left: {}", new Object[]{permitsToRelease, this.id, this.semaphore.availablePermits()});
    }

    private int getPermitsToRelease(int amount) {
        return this.hasAcquiredFullPermits.compareAndSet(true, false) ? this.totalPermits - (this.batchSize - amount) : amount;
    }

    private void maybeSwitchToHighThroughputMode(int amount) {
        if (CurrentThroughputMode.LOW.equals((Object)this.currentThroughputMode)) {
            logger.debug("{} permit(s) returned, setting high throughput mode for {}. Permits left: {}", new Object[]{amount, this.id, this.semaphore.availablePermits()});
            this.currentThroughputMode = CurrentThroughputMode.HIGH;
        }
    }

    @Override
    public boolean drain(Duration timeout) {
        logger.debug("Waiting for up to {} seconds for approx. {} permits to be released for {}", new Object[]{timeout.getSeconds(), this.totalPermits - this.semaphore.availablePermits(), this.id});
        try {
            return this.semaphore.tryAcquire(this.totalPermits, (int)timeout.getSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting to acquire permits", e);
        }
    }

    public static class Builder {
        private int batchSize;
        private int totalPermits;
        private Duration acquireTimeout;
        private BackPressureMode backPressureMode;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder totalPermits(int totalPermits) {
            this.totalPermits = totalPermits;
            return this;
        }

        public Builder acquireTimeout(Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            return this;
        }

        public Builder throughputConfiguration(BackPressureMode backPressureConfiguration) {
            this.backPressureMode = backPressureConfiguration;
            return this;
        }

        public SemaphoreBackPressureHandler build() {
            Assert.noNullElements(Arrays.asList(new Serializable[]{Integer.valueOf(this.batchSize), Integer.valueOf(this.totalPermits), this.acquireTimeout, this.backPressureMode}), (String)"Missing configuration");
            return new SemaphoreBackPressureHandler(this);
        }
    }

    private static enum CurrentThroughputMode {
        HIGH,
        LOW;

    }
}

