/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.config;

import io.awspring.cloud.sqs.ConfigUtils;
import io.awspring.cloud.sqs.config.Endpoint;
import io.awspring.cloud.sqs.config.HandlerMethodEndpoint;
import io.awspring.cloud.sqs.config.MessageListenerContainerFactory;
import io.awspring.cloud.sqs.listener.AbstractMessageListenerContainer;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.ContainerComponentFactory;
import io.awspring.cloud.sqs.listener.ContainerOptions;
import io.awspring.cloud.sqs.listener.MessageListener;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.AsyncAcknowledgementResultCallback;
import io.awspring.cloud.sqs.listener.errorhandler.AsyncErrorHandler;
import io.awspring.cloud.sqs.listener.errorhandler.ErrorHandler;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import io.awspring.cloud.sqs.listener.interceptor.MessageInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainerFactory<T, C extends MessageListenerContainer<T>>
implements MessageListenerContainerFactory<C> {
    private final ContainerOptions.Builder containerOptionsBuilder;
    private final Collection<AsyncMessageInterceptor<T>> asyncMessageInterceptors = new ArrayList<AsyncMessageInterceptor<T>>();
    private final Collection<MessageInterceptor<T>> messageInterceptors = new ArrayList<MessageInterceptor<T>>();
    private AsyncErrorHandler<T> asyncErrorHandler;
    private ErrorHandler<T> errorHandler;
    private AsyncMessageListener<T> asyncMessageListener;
    private MessageListener<T> messageListener;
    private AsyncAcknowledgementResultCallback<T> asyncAcknowledgementResultCallback;
    private AcknowledgementResultCallback<T> acknowledgementResultCallback;
    private Collection<ContainerComponentFactory<T>> containerComponentFactories;

    protected AbstractMessageListenerContainerFactory() {
        this.containerOptionsBuilder = ContainerOptions.builder();
    }

    public void setErrorHandler(ErrorHandler<T> errorHandler) {
        Assert.notNull(errorHandler, (String)"errorHandler cannot be null");
        this.errorHandler = errorHandler;
    }

    public void setErrorHandler(AsyncErrorHandler<T> errorHandler) {
        Assert.notNull(errorHandler, (String)"errorHandler cannot be null");
        this.asyncErrorHandler = errorHandler;
    }

    public void addMessageInterceptor(MessageInterceptor<T> messageInterceptor) {
        Assert.notNull(messageInterceptor, (String)"messageInterceptor cannot be null");
        this.messageInterceptors.add(messageInterceptor);
    }

    public void addMessageInterceptor(AsyncMessageInterceptor<T> messageInterceptor) {
        Assert.notNull(messageInterceptor, (String)"messageInterceptor cannot be null");
        this.asyncMessageInterceptors.add(messageInterceptor);
    }

    public void setMessageListener(MessageListener<T> messageListener) {
        Assert.notNull(messageListener, (String)"messageListener cannot be null");
        this.messageListener = messageListener;
    }

    public void setAsyncMessageListener(AsyncMessageListener<T> messageListener) {
        Assert.notNull(messageListener, (String)"messageListener cannot be null");
        this.asyncMessageListener = messageListener;
    }

    public void setAcknowledgementResultCallback(AsyncAcknowledgementResultCallback<T> acknowledgementResultCallback) {
        Assert.notNull(acknowledgementResultCallback, (String)"acknowledgementResultCallback cannot be null");
        this.asyncAcknowledgementResultCallback = acknowledgementResultCallback;
    }

    public void setAcknowledgementResultCallback(AcknowledgementResultCallback<T> acknowledgementResultCallback) {
        Assert.notNull(acknowledgementResultCallback, (String)"acknowledgementResultCallback cannot be null");
        this.acknowledgementResultCallback = acknowledgementResultCallback;
    }

    public void setContainerComponentFactories(Collection<ContainerComponentFactory<T>> containerComponentFactories) {
        Assert.notEmpty(containerComponentFactories, (String)"containerComponentFactories cannot be null or empty");
        this.containerComponentFactories = containerComponentFactories;
    }

    public void configure(Consumer<ContainerOptions.Builder> options) {
        options.accept(this.containerOptionsBuilder);
    }

    @Override
    public C createContainer(Endpoint endpoint) {
        Assert.notNull((Object)endpoint, (String)"endpoint cannot be null");
        ContainerOptions.Builder options = this.containerOptionsBuilder.createCopy();
        this.configure(endpoint, options);
        C container = this.createContainerInstance(endpoint, options.build());
        endpoint.setupContainer(container);
        this.configureContainer(container, endpoint);
        return container;
    }

    private void configure(Endpoint endpoint, ContainerOptions.Builder options) {
        ConfigUtils.INSTANCE.acceptIfInstance(endpoint, HandlerMethodEndpoint.class, abstractEndpoint -> abstractEndpoint.configureListenerMode(options::listenerMode));
        this.configureContainerOptions(endpoint, options);
    }

    protected void configureContainerOptions(Endpoint endpoint, ContainerOptions.Builder containerOptions) {
    }

    @Override
    public C createContainer(String ... logicalEndpointNames) {
        Assert.notEmpty((Object[])logicalEndpointNames, (String)"endpointNames cannot be empty");
        return this.createContainer(new EndpointAdapter(Arrays.asList(logicalEndpointNames)));
    }

    protected void configureContainer(C container, Endpoint endpoint) {
        ConfigUtils.INSTANCE.acceptIfInstance(container, AbstractMessageListenerContainer.class, abstractContainer -> this.configureAbstractContainer((AbstractMessageListenerContainer<T>)abstractContainer, endpoint));
    }

    protected void configureAbstractContainer(AbstractMessageListenerContainer<T> container, Endpoint endpoint) {
        container.setQueueNames(endpoint.getLogicalNames());
        ConfigUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), container::setId).acceptIfNotNull(this.containerComponentFactories, container::setComponentFactories).acceptIfNotNull(this.messageListener, container::setMessageListener).acceptIfNotNull(this.asyncMessageListener, container::setAsyncMessageListener).acceptIfNotNull(this.errorHandler, container::setErrorHandler).acceptIfNotNull(this.asyncErrorHandler, container::setErrorHandler).acceptIfNotNull(this.asyncAcknowledgementResultCallback, container::setAcknowledgementResultCallback).acceptIfNotNull(this.acknowledgementResultCallback, container::setAcknowledgementResultCallback).acceptIfNotEmpty(this.messageInterceptors, interceptors -> interceptors.forEach(container::addMessageInterceptor)).acceptIfNotEmpty(this.asyncMessageInterceptors, interceptors -> interceptors.forEach(container::addMessageInterceptor));
    }

    protected abstract C createContainerInstance(Endpoint var1, ContainerOptions var2);

    private static class EndpointAdapter
    implements Endpoint {
        private final Collection<String> endpointNames;

        public EndpointAdapter(Collection<String> endpointNames) {
            this.endpointNames = endpointNames;
        }

        public void setupContainer(MessageListenerContainer container) {
        }

        @Override
        public Collection<String> getLogicalNames() {
            return this.endpointNames;
        }

        @Override
        public String getListenerContainerFactoryName() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

