/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.LifecycleHandler;
import io.awspring.cloud.sqs.listener.MessageListenerContainer;
import io.awspring.cloud.sqs.listener.MessageListenerContainerRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultListenerContainerRegistry
implements MessageListenerContainerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultListenerContainerRegistry.class);
    private final Map<String, MessageListenerContainer<?>> listenerContainers = new ConcurrentHashMap();
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    @Override
    public void registerListenerContainer(MessageListenerContainer<?> listenerContainer) {
        Assert.isTrue((this.getContainerById(listenerContainer.getId()) == null ? 1 : 0) != 0, () -> "Already registered container with id " + listenerContainer.getId());
        logger.debug("Registering listener container {}", (Object)listenerContainer.getId());
        this.listenerContainers.put(listenerContainer.getId(), listenerContainer);
    }

    @Override
    public Collection<MessageListenerContainer<?>> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    @Override
    @Nullable
    public MessageListenerContainer<?> getContainerById(String id) {
        Assert.notNull((Object)id, (String)"id cannot be null.");
        return this.listenerContainers.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            logger.debug("Starting {}", (Object)this.getClass().getSimpleName());
            LifecycleHandler.get().start(this.listenerContainers.values());
            this.running = true;
            logger.debug("{} started", (Object)this.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            logger.debug("Stopping {}", (Object)this.getClass().getSimpleName());
            this.running = false;
            LifecycleHandler.get().stop(this.listenerContainers.values());
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

