/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.BackPressureMode;
import io.awspring.cloud.sqs.listener.ConfigurableContainerComponent;
import io.awspring.cloud.sqs.listener.ListenerMode;
import io.awspring.cloud.sqs.listener.QueueNotFoundStrategy;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementOrdering;
import io.awspring.cloud.sqs.listener.acknowledgement.handler.AcknowledgementMode;
import io.awspring.cloud.sqs.support.converter.MessagingMessageConverter;
import io.awspring.cloud.sqs.support.converter.SqsMessagingMessageConverter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class ContainerOptions {
    private final int maxInflightMessagesPerQueue;
    private final int maxMessagesPerPoll;
    private final Duration pollTimeout;
    private final Duration permitAcquireTimeout;
    private final Duration shutdownTimeout;
    private final BackPressureMode backPressureMode;
    private final ListenerMode listenerMode;
    private final Collection<QueueAttributeName> queueAttributeNames;
    private final Collection<String> messageAttributeNames;
    private final Collection<String> messageSystemAttributeNames;
    private final MessagingMessageConverter<?> messageConverter;
    private final AcknowledgementMode acknowledgementMode;
    private final QueueNotFoundStrategy queueNotFoundStrategy;
    private final AcknowledgementOrdering acknowledgementOrdering;
    private final Duration acknowledgementInterval;
    private final Integer acknowledgementThreshold;
    private final TaskExecutor componentsTaskExecutor;
    private final Duration messageVisibility;

    protected ContainerOptions(Builder builder) {
        this.maxInflightMessagesPerQueue = builder.maxInflightMessagesPerQueue;
        this.maxMessagesPerPoll = builder.maxMessagesPerPoll;
        this.pollTimeout = builder.pollTimeout;
        this.permitAcquireTimeout = builder.permitAcquireTimeout;
        this.shutdownTimeout = builder.shutdownTimeout;
        this.backPressureMode = builder.backPressureMode;
        this.listenerMode = builder.listenerMode;
        this.queueAttributeNames = builder.queueAttributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.messageSystemAttributeNames = builder.messageSystemAttributeNames;
        this.messageConverter = builder.messageConverter;
        this.acknowledgementMode = builder.acknowledgementMode;
        this.queueNotFoundStrategy = builder.queueNotFoundStrategy;
        this.acknowledgementOrdering = builder.acknowledgementOrdering;
        this.acknowledgementInterval = builder.acknowledgementInterval;
        this.acknowledgementThreshold = builder.acknowledgementThreshold;
        this.componentsTaskExecutor = builder.componentsTaskExecutor;
        this.messageVisibility = builder.messageVisibility;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxInFlightMessagesPerQueue() {
        return this.maxInflightMessagesPerQueue;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public Duration getPollTimeout() {
        return this.pollTimeout;
    }

    public Duration getPermitAcquireTimeout() {
        return this.permitAcquireTimeout;
    }

    public TaskExecutor getComponentsTaskExecutor() {
        return this.componentsTaskExecutor;
    }

    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public BackPressureMode getBackPressureMode() {
        return this.backPressureMode;
    }

    public ListenerMode getListenerMode() {
        return this.listenerMode;
    }

    public Collection<QueueAttributeName> getQueueAttributeNames() {
        return this.queueAttributeNames;
    }

    public Collection<String> getMessageAttributeNames() {
        return this.messageAttributeNames;
    }

    public Collection<String> getMessageSystemAttributeNames() {
        return this.messageSystemAttributeNames;
    }

    public Duration getMessageVisibility() {
        return this.messageVisibility;
    }

    public MessagingMessageConverter<?> getMessageConverter() {
        return this.messageConverter;
    }

    public Duration getAcknowledgementInterval() {
        return this.acknowledgementInterval;
    }

    public Integer getAcknowledgementThreshold() {
        return this.acknowledgementThreshold;
    }

    public AcknowledgementMode getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public AcknowledgementOrdering getAcknowledgementOrdering() {
        return this.acknowledgementOrdering;
    }

    public QueueNotFoundStrategy getQueueNotFoundStrategy() {
        return this.queueNotFoundStrategy;
    }

    public ContainerOptions configure(ConfigurableContainerComponent configurable) {
        configurable.configure(this);
        return this;
    }

    public ContainerOptions configure(Collection<? extends ConfigurableContainerComponent> configurables) {
        configurables.forEach(this::configure);
        return this;
    }

    public ContainerOptions createCopy() {
        ContainerOptions newCopy = ContainerOptions.builder().build();
        ReflectionUtils.shallowCopyFieldState((Object)this, (Object)newCopy);
        return newCopy;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private static final int DEFAULT_MAX_INFLIGHT_MSG_PER_QUEUE = 10;
        private static final int DEFAULT_MAX_MESSAGES_PER_POLL = 10;
        private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofSeconds(10L);
        private static final Duration DEFAULT_SEMAPHORE_TIMEOUT = Duration.ofSeconds(10L);
        private static final Duration DEFAULT_SHUTDOWN_TIMEOUT = Duration.ofSeconds(20L);
        private static final BackPressureMode DEFAULT_THROUGHPUT_CONFIGURATION = BackPressureMode.AUTO;
        private static final ListenerMode DEFAULT_MESSAGE_DELIVERY_STRATEGY = ListenerMode.SINGLE_MESSAGE;
        private static final List<QueueAttributeName> DEFAULT_QUEUE_ATTRIBUTES_NAMES = Collections.emptyList();
        private static final List<String> DEFAULT_MESSAGE_ATTRIBUTES_NAMES = Collections.singletonList(QueueAttributeName.ALL.toString());
        private static final List<String> DEFAULT_MESSAGE_SYSTEM_ATTRIBUTES = Collections.singletonList(QueueAttributeName.ALL.toString());
        private static final MessagingMessageConverter<?> DEFAULT_MESSAGE_CONVERTER = new SqsMessagingMessageConverter();
        private static final AcknowledgementMode DEFAULT_ACKNOWLEDGEMENT_MODE = AcknowledgementMode.ON_SUCCESS;
        private static final QueueNotFoundStrategy DEFAULT_QUEUE_NOT_FOUND_STRATEGY = QueueNotFoundStrategy.CREATE;
        private int maxInflightMessagesPerQueue = 10;
        private int maxMessagesPerPoll = 10;
        private Duration pollTimeout = DEFAULT_POLL_TIMEOUT;
        private Duration permitAcquireTimeout = DEFAULT_SEMAPHORE_TIMEOUT;
        private BackPressureMode backPressureMode = DEFAULT_THROUGHPUT_CONFIGURATION;
        private Duration shutdownTimeout = DEFAULT_SHUTDOWN_TIMEOUT;
        private ListenerMode listenerMode = DEFAULT_MESSAGE_DELIVERY_STRATEGY;
        private Collection<QueueAttributeName> queueAttributeNames = DEFAULT_QUEUE_ATTRIBUTES_NAMES;
        private Collection<String> messageAttributeNames = DEFAULT_MESSAGE_ATTRIBUTES_NAMES;
        private Collection<String> messageSystemAttributeNames = DEFAULT_MESSAGE_SYSTEM_ATTRIBUTES;
        private MessagingMessageConverter<?> messageConverter = DEFAULT_MESSAGE_CONVERTER;
        private QueueNotFoundStrategy queueNotFoundStrategy = DEFAULT_QUEUE_NOT_FOUND_STRATEGY;
        private AcknowledgementMode acknowledgementMode = DEFAULT_ACKNOWLEDGEMENT_MODE;
        private AcknowledgementOrdering acknowledgementOrdering;
        private Duration acknowledgementInterval;
        private Integer acknowledgementThreshold;
        private TaskExecutor componentsTaskExecutor;
        private Duration messageVisibility;

        protected Builder() {
        }

        protected Builder(ContainerOptions options) {
            this.maxInflightMessagesPerQueue = options.maxInflightMessagesPerQueue;
            this.maxMessagesPerPoll = options.maxMessagesPerPoll;
            this.pollTimeout = options.pollTimeout;
            this.permitAcquireTimeout = options.permitAcquireTimeout;
            this.shutdownTimeout = options.shutdownTimeout;
            this.backPressureMode = options.backPressureMode;
            this.listenerMode = options.listenerMode;
            this.queueAttributeNames = options.queueAttributeNames;
            this.messageAttributeNames = options.messageAttributeNames;
            this.messageSystemAttributeNames = options.messageSystemAttributeNames;
            this.messageConverter = options.messageConverter;
            this.acknowledgementMode = options.acknowledgementMode;
            this.queueNotFoundStrategy = options.queueNotFoundStrategy;
            this.acknowledgementOrdering = options.acknowledgementOrdering;
            this.acknowledgementInterval = options.acknowledgementInterval;
            this.acknowledgementThreshold = options.acknowledgementThreshold;
            this.componentsTaskExecutor = options.componentsTaskExecutor;
            this.messageVisibility = options.messageVisibility;
        }

        public Builder maxInflightMessagesPerQueue(int maxInflightMessagesPerQueue) {
            Assert.isTrue((maxInflightMessagesPerQueue > 0 ? 1 : 0) != 0, (String)"maxInflightMessagesPerQueue must be greater than zero");
            this.maxInflightMessagesPerQueue = maxInflightMessagesPerQueue;
            return this;
        }

        public Builder maxMessagesPerPoll(int maxMessagesPerPoll) {
            this.maxMessagesPerPoll = maxMessagesPerPoll;
            return this;
        }

        public Builder pollTimeout(Duration pollTimeout) {
            Assert.notNull((Object)pollTimeout, (String)"pollTimeout cannot be null");
            this.pollTimeout = pollTimeout;
            return this;
        }

        public Builder permitAcquireTimeout(Duration permitAcquireTimeout) {
            Assert.notNull((Object)permitAcquireTimeout, (String)"semaphoreAcquireTimeout cannot be null");
            this.permitAcquireTimeout = permitAcquireTimeout;
            return this;
        }

        public Builder listenerMode(ListenerMode listenerMode) {
            Assert.notNull((Object)((Object)listenerMode), (String)"listenerMode cannot be null");
            this.listenerMode = listenerMode;
            return this;
        }

        public Builder componentsTaskExecutor(TaskExecutor taskExecutor) {
            Assert.notNull((Object)taskExecutor, (String)"taskExecutor cannot be null");
            this.componentsTaskExecutor = taskExecutor;
            return this;
        }

        public Builder shutdownTimeout(Duration shutdownTimeout) {
            Assert.notNull((Object)shutdownTimeout, (String)"shutdownTimeout cannot be null");
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public Builder backPressureMode(BackPressureMode backPressureMode) {
            Assert.notNull((Object)((Object)backPressureMode), (String)"backPressureMode cannot be null");
            this.backPressureMode = backPressureMode;
            return this;
        }

        public Builder queueAttributeNames(Collection<QueueAttributeName> queueAttributeNames) {
            Assert.notEmpty(queueAttributeNames, (String)"queueAttributeNames cannot be empty");
            this.queueAttributeNames = Collections.unmodifiableCollection(new ArrayList<QueueAttributeName>(queueAttributeNames));
            return this;
        }

        public Builder messageAttributeNames(Collection<String> messageAttributeNames) {
            Assert.notEmpty(messageAttributeNames, (String)"messageAttributeNames cannot be empty");
            this.messageAttributeNames = Collections.unmodifiableCollection(new ArrayList<String>(messageAttributeNames));
            return this;
        }

        public Builder messageSystemAttributeNames(Collection<MessageSystemAttributeName> messageSystemAttributeNames) {
            Assert.notEmpty(messageSystemAttributeNames, (String)"messageSystemAttributeNames cannot be empty");
            this.messageSystemAttributeNames = messageSystemAttributeNames.stream().map(MessageSystemAttributeName::toString).collect(Collectors.toList());
            return this;
        }

        public Builder messageVisibility(Duration messageVisibility) {
            Assert.notNull((Object)messageVisibility, (String)"messageVisibility cannot be null");
            this.messageVisibility = messageVisibility;
            return this;
        }

        public Builder acknowledgementInterval(Duration acknowledgementInterval) {
            Assert.notNull((Object)acknowledgementInterval, (String)"acknowledgementInterval cannot be null");
            this.acknowledgementInterval = acknowledgementInterval;
            return this;
        }

        public Builder acknowledgementThreshold(int acknowledgementThreshold) {
            Assert.isTrue((acknowledgementThreshold >= 0 ? 1 : 0) != 0, (String)"acknowledgementThreshold must be greater than or equal to zero");
            this.acknowledgementThreshold = acknowledgementThreshold;
            return this;
        }

        public Builder acknowledgementMode(AcknowledgementMode acknowledgementMode) {
            Assert.notNull((Object)((Object)acknowledgementMode), (String)"acknowledgementMode cannot be null");
            this.acknowledgementMode = acknowledgementMode;
            return this;
        }

        public Builder acknowledgementOrdering(AcknowledgementOrdering acknowledgementOrdering) {
            Assert.notNull((Object)((Object)acknowledgementOrdering), (String)"acknowledgementOrdering cannot be null");
            this.acknowledgementOrdering = acknowledgementOrdering;
            return this;
        }

        public Builder messageConverter(MessagingMessageConverter<?> messageConverter) {
            Assert.notNull(messageConverter, (String)"messageConverter cannot be null");
            this.messageConverter = messageConverter;
            return this;
        }

        public Builder queueNotFoundStrategy(QueueNotFoundStrategy queueNotFoundStrategy) {
            Assert.notNull((Object)((Object)queueNotFoundStrategy), (String)"queueNotFoundStrategy cannot be null");
            this.queueNotFoundStrategy = queueNotFoundStrategy;
            return this;
        }

        public ContainerOptions build() {
            Assert.isTrue((this.maxMessagesPerPoll <= this.maxInflightMessagesPerQueue ? 1 : 0) != 0, (String)String.format("messagesPerPoll should be less than or equal to maxInflightMessagesPerQueue. Values provided: %s and %s respectively", this.maxMessagesPerPoll, this.maxInflightMessagesPerQueue));
            return new ContainerOptions(this);
        }

        public Builder createCopy() {
            Builder newCopy = ContainerOptions.builder();
            ReflectionUtils.shallowCopyFieldState((Object)this, (Object)newCopy);
            return newCopy;
        }

        public void fromBuilder(Builder builder) {
            ReflectionUtils.shallowCopyFieldState((Object)builder, (Object)this);
        }
    }
}

