/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.integration;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.utils.PatternMatchUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;

public class SnsHeaderMapper
implements HeaderMapper<Map<String, MessageAttributeValue>> {
    private final Log logger = LogFactory.getLog(SnsHeaderMapper.class);
    private volatile String[] outboundHeaderNames = new String[]{"!id", "!timestamp", "!nativeHeaders", "!Sns_messageId", "!Sns_topicArn", "*"};

    public void setOutboundHeaderNames(String ... outboundHeaderNames) {
        Assert.notNull((Object)outboundHeaderNames, (String)"'outboundHeaderNames' must not be null.");
        Assert.noNullElements((Object[])outboundHeaderNames, (String)"'outboundHeaderNames' must not contains null elements.");
        Arrays.sort(outboundHeaderNames);
        this.outboundHeaderNames = outboundHeaderNames;
    }

    public void fromHeaders(MessageHeaders headers, Map<String, MessageAttributeValue> target) {
        for (Map.Entry messageHeader : headers.entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if (!Boolean.TRUE.equals(PatternMatchUtils.smartMatch((String)messageHeaderName, (String[])this.outboundHeaderNames))) continue;
            if (messageHeaderValue instanceof UUID || messageHeaderValue instanceof MimeType || messageHeaderValue instanceof Boolean || messageHeaderValue instanceof String) {
                target.put(messageHeaderName, SnsHeaderMapper.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                target.put(messageHeaderName, SnsHeaderMapper.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)messageHeaderValue;
                target.put(messageHeaderName, SnsHeaderMapper.getBinaryMessageAttribute(byteBuffer));
                continue;
            }
            if (messageHeaderValue instanceof byte[]) {
                byte[] bytes = (byte[])messageHeaderValue;
                target.put(messageHeaderName, SnsHeaderMapper.getBinaryMessageAttribute(ByteBuffer.wrap(bytes)));
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by the current AWS service.", messageHeaderName, messageHeaderValue.getClass().getName()));
        }
    }

    private static MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return SnsHeaderMapper.buildMessageAttribute("Binary", messageHeaderValue);
    }

    private static MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return SnsHeaderMapper.buildMessageAttribute("String", messageHeaderValue);
    }

    private static MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Class<?> messageHeaderValueClass = messageHeaderValue.getClass();
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValueClass), (String)"Only standard number types are accepted as message header.");
        return SnsHeaderMapper.buildMessageAttribute("Number." + messageHeaderValueClass.getName(), messageHeaderValue);
    }

    private static MessageAttributeValue buildMessageAttribute(String dataType, Object value) {
        MessageAttributeValue.Builder messageAttributeValue = MessageAttributeValue.builder().dataType(dataType);
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)value;
            messageAttributeValue.binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer));
        } else {
            messageAttributeValue.stringValue(value.toString());
        }
        return (MessageAttributeValue)messageAttributeValue.build();
    }

    public Map<String, Object> toHeaders(Map<String, MessageAttributeValue> source) {
        throw new UnsupportedOperationException("The mapping from AWS Response Message is not supported");
    }
}

