/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.integration;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public final class SnsBodyBuilder {
    private final Map<String, String> snsMessage = new HashMap<String, String>();

    private SnsBodyBuilder(String defaultMessage) {
        Assert.hasText((String)defaultMessage, (String)"defaultMessage must not be empty.");
        this.snsMessage.put("default", defaultMessage);
    }

    public SnsBodyBuilder forProtocols(String message, String ... protocols) {
        Assert.hasText((String)message, (String)"message must not be empty.");
        Assert.notEmpty((Object[])protocols, (String)"protocols must not be empty.");
        for (String protocol : protocols) {
            Assert.hasText((String)protocol, (String)"protocols must not contain empty elements.");
            this.snsMessage.put(protocol, message);
        }
        return this;
    }

    public String build() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Map.Entry<String, String> entry : this.snsMessage.entrySet()) {
            stringBuilder.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue().replaceAll("\"", "\\\\\"")).append("\",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1) + "}";
    }

    public static SnsBodyBuilder withDefault(String defaultMessage) {
        return new SnsBodyBuilder(defaultMessage);
    }
}

