/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.core;

import io.awspring.cloud.sns.core.CachingTopicArnResolver;
import io.awspring.cloud.sns.core.DefaultTopicArnResolver;
import io.awspring.cloud.sns.core.SnsNotification;
import io.awspring.cloud.sns.core.SnsOperations;
import io.awspring.cloud.sns.core.TopicArnResolver;
import io.awspring.cloud.sns.core.TopicMessageChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sns.SnsClient;

public class SnsTemplate
extends AbstractMessageSendingTemplate<TopicMessageChannel>
implements DestinationResolvingMessageSendingOperations<TopicMessageChannel>,
SnsOperations {
    private final SnsClient snsClient;
    private final TopicArnResolver topicArnResolver;
    private final List<ChannelInterceptor> channelInterceptors = new ArrayList<ChannelInterceptor>();

    public SnsTemplate(SnsClient snsClient) {
        this(snsClient, null);
    }

    public SnsTemplate(SnsClient snsClient, @Nullable MessageConverter messageConverter) {
        this(snsClient, new CachingTopicArnResolver(new DefaultTopicArnResolver(snsClient)), messageConverter);
    }

    public SnsTemplate(SnsClient snsClient, TopicArnResolver topicArnResolver, @Nullable MessageConverter messageConverter) {
        Assert.notNull((Object)snsClient, (String)"SnsClient must not be null");
        Assert.notNull((Object)topicArnResolver, (String)"topicArnResolver must not be null");
        this.topicArnResolver = topicArnResolver;
        this.snsClient = snsClient;
        if (messageConverter != null) {
            this.setMessageConverter((MessageConverter)SnsTemplate.initMessageConverter(messageConverter));
        }
    }

    public void setDefaultDestinationName(@Nullable String defaultDestination) {
        super.setDefaultDestination(defaultDestination == null ? null : this.resolveMessageChannelByTopicName(defaultDestination));
    }

    protected void doSend(TopicMessageChannel destination, Message<?> message) {
        destination.send(message);
    }

    public void send(String destination, Message<?> message) throws MessagingException {
        this.doSend(this.resolveMessageChannelByTopicName(destination), message);
    }

    public <T> void convertAndSend(String destination, T payload) throws MessagingException {
        this.convertAndSend(destination, payload, null, null);
    }

    public <T> void convertAndSend(String destination, T payload, @Nullable Map<String, Object> headers) throws MessagingException {
        this.convertAndSend(destination, payload, headers, null);
    }

    public <T> void convertAndSend(String destination, T payload, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        this.convertAndSend(destination, payload, null, postProcessor);
    }

    public <T> void convertAndSend(String destination, T payload, @Nullable Map<String, Object> headers, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        this.convertAndSend((Object)this.resolveMessageChannelByTopicName(destination), payload, headers, postProcessor);
    }

    public void sendNotification(String destinationName, Object message, @Nullable String subject) {
        this.convertAndSend(destinationName, message, Collections.singletonMap("notification-subject", subject));
    }

    public void sendNotification(Object message, @Nullable String subject) {
        this.convertAndSend((Object)((TopicMessageChannel)((Object)this.getRequiredDefaultDestination())), message, Collections.singletonMap("notification-subject", subject));
    }

    public void addChannelInterceptor(ChannelInterceptor channelInterceptor) {
        Assert.notNull((Object)channelInterceptor, (String)"channelInterceptor cannot be null");
        this.channelInterceptors.add(channelInterceptor);
    }

    @Override
    public void sendNotification(String topic, SnsNotification<?> notification) {
        this.convertAndSend(topic, notification.getPayload(), notification.getHeaders());
    }

    private TopicMessageChannel resolveMessageChannelByTopicName(String topicName) {
        Arn topicArn = this.topicArnResolver.resolveTopicArn(topicName);
        TopicMessageChannel topicMessageChannel = new TopicMessageChannel(this.snsClient, topicArn);
        this.channelInterceptors.forEach(arg_0 -> ((TopicMessageChannel)topicMessageChannel).addInterceptor(arg_0));
        return topicMessageChannel;
    }

    private static CompositeMessageConverter initMessageConverter(@Nullable MessageConverter messageConverter) {
        ArrayList<Object> converters = new ArrayList<Object>();
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        converters.add(stringMessageConverter);
        if (messageConverter != null) {
            converters.add(messageConverter);
        }
        return new CompositeMessageConverter(converters);
    }
}

