/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.ses;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.SendEmailRequest;
import software.amazon.awssdk.services.ses.model.SendEmailResponse;
import software.amazon.awssdk.services.ses.model.SesException;

public class SimpleEmailServiceMailSender
implements MailSender,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEmailServiceMailSender.class);
    private final SesClient sesClient;
    @Nullable
    private final String sourceArn;

    public SimpleEmailServiceMailSender(SesClient sesClient) {
        this(sesClient, null);
    }

    public SimpleEmailServiceMailSender(SesClient sesClient, @Nullable String sourceArn) {
        this.sesClient = sesClient;
        this.sourceArn = sourceArn;
    }

    public void destroy() {
        this.sesClient.close();
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        Assert.notNull((Object)simpleMessage, (String)"simpleMessage are required");
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        Assert.notNull((Object)simpleMessages, (String)"simpleMessages are required");
        HashMap<SimpleMailMessage, SesException> failedMessages = new HashMap<SimpleMailMessage, SesException>();
        for (SimpleMailMessage simpleMessage : simpleMessages) {
            try {
                SendEmailResponse sendEmailResult = this.getEmailService().sendEmail(this.prepareMessage(simpleMessage));
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Message with id: {} successfully send", (Object)sendEmailResult.messageId());
            }
            catch (SesException e) {
                failedMessages.put(simpleMessage, e);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    protected SesClient getEmailService() {
        return this.sesClient;
    }

    @Nullable
    protected String getSourceArn() {
        return this.sourceArn;
    }

    private SendEmailRequest prepareMessage(SimpleMailMessage simpleMailMessage) {
        Assert.notNull((Object)simpleMailMessage, (String)"simpleMailMessage are required");
        Destination.Builder destinationBuilder = Destination.builder();
        destinationBuilder.toAddresses(simpleMailMessage.getTo());
        if (simpleMailMessage.getCc() != null) {
            destinationBuilder.ccAddresses(simpleMailMessage.getCc());
        }
        if (simpleMailMessage.getBcc() != null) {
            destinationBuilder.bccAddresses(simpleMailMessage.getBcc());
        }
        Content subject = (Content)Content.builder().data(simpleMailMessage.getSubject()).build();
        Body body = (Body)Body.builder().text((Content)Content.builder().data(simpleMailMessage.getText()).build()).build();
        Message message = (Message)Message.builder().body(body).subject(subject).build();
        SendEmailRequest.Builder emailRequestBuilder = SendEmailRequest.builder().destination((Destination)destinationBuilder.build()).source(simpleMailMessage.getFrom()).sourceArn(this.getSourceArn()).message(message);
        if (StringUtils.hasText((String)simpleMailMessage.getReplyTo())) {
            emailRequestBuilder.replyToAddresses(new String[]{simpleMailMessage.getReplyTo()});
        }
        return (SendEmailRequest)emailRequestBuilder.build();
    }
}

