/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerProperties;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySource;
import io.awspring.cloud.secretsmanager.AwsSecretsManagerPropertySources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class AwsSecretsManagerPropertySourceLocator
implements PropertySourceLocator {
    private final String propertySourceName;
    private final AWSSecretsManager smClient;
    private final AwsSecretsManagerProperties properties;
    private final Set<String> contexts = new LinkedHashSet<String>();

    public AwsSecretsManagerPropertySourceLocator(String propertySourceName, AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        this.propertySourceName = propertySourceName;
        this.smClient = smClient;
        this.properties = properties;
    }

    public AwsSecretsManagerPropertySourceLocator(AWSSecretsManager smClient, AwsSecretsManagerProperties properties) {
        this("aws-secrets-manager", smClient, properties);
    }

    public List<String> getContexts() {
        return new ArrayList<String>(this.contexts);
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        AwsSecretsManagerPropertySources sources = new AwsSecretsManagerPropertySources(this.properties);
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        List<String> contexts = sources.getAutomaticContexts(profiles);
        Collections.reverse(contexts);
        this.contexts.addAll(contexts);
        CompositePropertySource composite = new CompositePropertySource(this.propertySourceName);
        for (String propertySourceContext : this.contexts) {
            AwsSecretsManagerPropertySource propertySource = sources.createPropertySource(propertySourceContext, !this.properties.isFailFast(), this.smClient);
            if (propertySource == null) continue;
            composite.addPropertySource((PropertySource)propertySource);
        }
        return composite;
    }
}

