/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import io.awspring.cloud.secretsmanager.ValidationException;
import java.net.URI;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="aws.secretsmanager")
public class AwsSecretsManagerProperties
implements InitializingBean {
    public static final String CONFIG_PREFIX = "aws.secretsmanager";
    private static final Pattern PREFIX_PATTERN = Pattern.compile("(/)?([a-zA-Z0-9.\\-]+)(?:/[a-zA-Z0-9]+)*");
    private static final Pattern PROFILE_SEPARATOR_PATTERN = Pattern.compile("[a-zA-Z0-9.\\-_/\\\\]+");
    private String prefix = "/secret";
    private String defaultContext = "application";
    private String profileSeparator = "_";
    private boolean failFast = true;
    private String region;
    private URI endpoint;
    private String name;
    private boolean enabled = true;

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasLength((String)this.prefix)) {
            throw new ValidationException("aws.secretsmanager.prefix", "prefix should not be empty or null.");
        }
        if (!StringUtils.hasLength((String)this.defaultContext)) {
            throw new ValidationException("aws.secretsmanager.defaultContext", "defaultContext should not be empty or null.");
        }
        if (!StringUtils.hasLength((String)this.profileSeparator)) {
            throw new ValidationException("aws.secretsmanager.profileSeparator", "profileSeparator should not be empty or null.");
        }
        if (!PREFIX_PATTERN.matcher(this.prefix).matches()) {
            throw new ValidationException("aws.secretsmanager.prefix", "The prefix must have pattern of:  " + PREFIX_PATTERN.toString());
        }
        if (!PROFILE_SEPARATOR_PATTERN.matcher(this.profileSeparator).matches()) {
            throw new ValidationException("aws.secretsmanager.profileSeparator", "The profileSeparator must have pattern of:  " + PROFILE_SEPARATOR_PATTERN.toString());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }
}

