/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3.integration;

import org.springframework.integration.file.filters.AbstractPersistentAcceptOnceFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3PersistentAcceptOnceFileListFilter
extends AbstractPersistentAcceptOnceFileListFilter<S3Object> {
    public S3PersistentAcceptOnceFileListFilter(ConcurrentMetadataStore store, String prefix) {
        super(store, prefix);
    }

    protected long modified(S3Object file) {
        return file != null ? file.lastModified().getEpochSecond() : 0L;
    }

    protected String fileName(S3Object file) {
        return file != null ? file.key() : null;
    }

    protected boolean isDirectory(S3Object file) {
        return false;
    }
}

