/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3Resource;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.springframework.lang.Nullable;

public interface S3Operations {
    public String createBucket(String var1);

    public void deleteBucket(String var1);

    public boolean bucketExists(String var1);

    public void deleteObject(String var1, String var2);

    public void deleteObject(String var1);

    public boolean objectExists(String var1, String var2);

    public List<S3Resource> listObjects(String var1, String var2);

    public S3Resource store(String var1, String var2, Object var3);

    public S3Resource createResource(String var1, String var2);

    public <T> T read(String var1, String var2, Class<T> var3);

    public S3Resource upload(String var1, String var2, InputStream var3, @Nullable ObjectMetadata var4);

    default public S3Resource upload(String bucketName, String key, InputStream inputStream) {
        return this.upload(bucketName, key, inputStream, null);
    }

    public S3Resource download(String var1, String var2);

    public URL createSignedGetURL(String var1, String var2, Duration var3);

    public URL createSignedPutURL(String var1, String var2, Duration var3, @Nullable ObjectMetadata var4, @Nullable String var5);

    default public URL createSignedPutURL(String bucketName, String key, Duration duration) {
        return this.createSignedPutURL(bucketName, key, duration, null, null);
    }
}

