/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStream;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.unit.DataSize;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class InMemoryBufferingS3OutputStream
extends S3OutputStream {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryBufferingS3OutputStream.class);
    public static final DataSize DEFAULT_BUFFER_CAPACITY = DataSize.ofMegabytes((long)5L);
    static final int DEFAULT_BUFFER_CAPACITY_IN_BYTES = (int)DEFAULT_BUFFER_CAPACITY.toBytes();
    private final Location location;
    private final S3Client s3Client;
    @Nullable
    private final ObjectMetadata objectMetadata;
    @Nullable
    private final S3ObjectContentTypeResolver contentTypeResolver;
    private final DataSize bufferSize;
    @Nullable
    private ByteArrayOutputStream outputStream;
    private final Object monitor = new Object();
    @Nullable
    private CreateMultipartUploadResponse multipartUploadResponse;
    private int partCounter = 1;
    private final List<CompletedPart> completedParts = new LinkedList<CompletedPart>();

    InMemoryBufferingS3OutputStream(Location location, S3Client s3Client, @Nullable ObjectMetadata objectMetadata, @Nullable S3ObjectContentTypeResolver contentTypeResolver, @Nullable DataSize bufferSize) {
        this.location = location;
        this.s3Client = s3Client;
        this.objectMetadata = objectMetadata;
        this.contentTypeResolver = contentTypeResolver;
        this.bufferSize = InMemoryBufferingS3OutputStream.computeBufferSize(bufferSize);
        this.outputStream = new ByteArrayOutputStream((int)this.bufferSize.toBytes());
    }

    private static DataSize computeBufferSize(@Nullable DataSize bufferSize) {
        if (bufferSize != null) {
            if (bufferSize.toBytes() >= DEFAULT_BUFFER_CAPACITY.toBytes()) {
                return bufferSize;
            }
            logger.warn("Buffer size {} is less than the minimum {}. Using minimum instead.", (Object)bufferSize, (Object)DEFAULT_BUFFER_CAPACITY);
        }
        return DEFAULT_BUFFER_CAPACITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if ((long)this.outputStream.size() == this.bufferSize.toBytes()) {
                if (!this.isMultiPartUpload()) {
                    this.createMultiPartUpload();
                }
                this.completedParts.add(this.uploadPart(this.outputStream.toByteArray(), this.multipartUploadResponse));
                this.outputStream.reset();
            }
            this.outputStream.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IllegalStateException("Stream is already closed. Too late to abort.");
            }
            if (this.isMultiPartUpload()) {
                this.abortMultiPartUpload(this.multipartUploadResponse);
            }
            this.outputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.isMultiPartUpload()) {
                this.completedParts.add(this.uploadPart(this.outputStream.toByteArray(), this.multipartUploadResponse));
                this.completeMultiPartUpload(this.multipartUploadResponse);
            } else {
                this.putObject(this.outputStream.toByteArray());
            }
            this.outputStream = null;
        }
    }

    private boolean isClosed() {
        return this.outputStream == null;
    }

    private boolean isMultiPartUpload() {
        return this.multipartUploadResponse != null;
    }

    private Optional<String> getHash(byte[] content) {
        try {
            return Optional.of(Base64.getEncoder().encodeToString(MessageDigest.getInstance("md5").digest(content)));
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            return Optional.empty();
        }
    }

    private void createMultiPartUpload() {
        try {
            this.multipartUploadResponse = this.s3Client.createMultipartUpload((CreateMultipartUploadRequest)((CreateMultipartUploadRequest.Builder)CreateMultipartUploadRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).applyMutation(builder -> {
                if (this.objectMetadata != null) {
                    this.objectMetadata.apply((CreateMultipartUploadRequest.Builder)builder);
                }
                this.applyContentType(arg_0 -> ((CreateMultipartUploadRequest.Builder)builder).contentType(arg_0));
            })).build());
        }
        catch (SdkException e) {
            throw new S3Exception("Failed to create multipart upload.", e);
        }
    }

    private CompletedPart uploadPart(byte[] content, CreateMultipartUploadResponse createMultipartUploadResponse) {
        UploadPartResponse response = this.s3Client.uploadPart((UploadPartRequest)((UploadPartRequest.Builder)UploadPartRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).contentLength(Long.valueOf(content.length)).uploadId(createMultipartUploadResponse.uploadId()).partNumber(Integer.valueOf(this.partCounter)).applyMutation(builder -> {
            this.getHash(content).ifPresent(arg_0 -> ((UploadPartRequest.Builder)builder).contentMD5(arg_0));
            if (this.objectMetadata != null) {
                this.objectMetadata.apply((UploadPartRequest.Builder)builder);
            }
        })).build(), RequestBody.fromBytes((byte[])content));
        return (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.partCounter++)).eTag(response.eTag()).build();
    }

    private void completeMultiPartUpload(CreateMultipartUploadResponse response) {
        try {
            this.s3Client.completeMultipartUpload((CompleteMultipartUploadRequest)((CompleteMultipartUploadRequest.Builder)CompleteMultipartUploadRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).uploadId(response.uploadId()).multipartUpload(multipartUpload -> multipartUpload.parts(this.completedParts)).applyMutation(builder -> {
                if (this.objectMetadata != null) {
                    this.objectMetadata.apply((CompleteMultipartUploadRequest.Builder)builder);
                }
            })).build());
        }
        catch (SdkException e) {
            this.abortMultiPartUpload(response);
            throw new S3Exception("Multipart upload failed.", e);
        }
    }

    private void abortMultiPartUpload(CreateMultipartUploadResponse response) {
        try {
            this.s3Client.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).uploadId(response.uploadId()).build());
        }
        catch (SdkException e) {
            logger.error("Failed to abort the upload with ID {}. The incomplete upload should be removed to avoid additional S3 charges.", (Object)response.uploadId());
            throw new S3Exception("Failed to abort the upload.", e);
        }
    }

    private void putObject(byte[] content) {
        try {
            this.s3Client.putObject((PutObjectRequest)((PutObjectRequest.Builder)PutObjectRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).contentLength(Long.valueOf(content.length)).applyMutation(builder -> {
                this.getHash(content).ifPresent(arg_0 -> ((PutObjectRequest.Builder)builder).contentMD5(arg_0));
                if (this.objectMetadata != null) {
                    this.objectMetadata.apply((PutObjectRequest.Builder)builder);
                }
                this.applyContentType(arg_0 -> ((PutObjectRequest.Builder)builder).contentType(arg_0));
            })).build(), RequestBody.fromBytes((byte[])content));
        }
        catch (SdkException e) {
            throw new S3Exception("Simple upload failed.", e);
        }
    }

    private void applyContentType(Consumer<String> consumer) {
        if (this.contentTypeResolver != null && (this.objectMetadata == null || this.objectMetadata.getContentType() == null)) {
            consumer.accept(this.contentTypeResolver.resolveContentType(this.location.getObject()));
        }
    }
}

