/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.s3.S3Client;

public class S3ProtocolResolver
implements ProtocolResolver,
ResourceLoaderAware,
BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ProtocolResolver.class);
    @Nullable
    private S3Client s3Client;
    @Nullable
    private S3OutputStreamProvider s3OutputStreamProvider;
    @Nullable
    private BeanFactory beanFactory;

    public S3ProtocolResolver() {
    }

    S3ProtocolResolver(@Nullable S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        S3Client s3Client = this.getS3Client();
        if (s3Client == null) {
            LOGGER.warn("Could not resolve S3Client. Resource {} could not be resolved", (Object)location);
            return null;
        }
        S3OutputStreamProvider s3OutputStreamProvider = this.getS3OutputStreamProvider();
        if (s3OutputStreamProvider == null) {
            LOGGER.warn("Could not resolve S3OutputStreamProvider. Resource {} could not be resolved", (Object)location);
            return null;
        }
        return S3Resource.create(location, s3Client, s3OutputStreamProvider);
    }

    @Nullable
    private S3OutputStreamProvider getS3OutputStreamProvider() {
        if (this.s3OutputStreamProvider != null) {
            return this.s3OutputStreamProvider;
        }
        if (this.beanFactory != null) {
            S3OutputStreamProvider s3OutputStreamProvider;
            this.s3OutputStreamProvider = s3OutputStreamProvider = (S3OutputStreamProvider)this.beanFactory.getBean(S3OutputStreamProvider.class);
            return s3OutputStreamProvider;
        }
        return null;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (DefaultResourceLoader.class.isAssignableFrom(resourceLoader.getClass())) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            LOGGER.warn("The provided delegate resource loader is not an implementation of DefaultResourceLoader. Custom Protocol using s3:// prefix will not be enabled.");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Nullable
    private S3Client getS3Client() {
        if (this.s3Client != null) {
            return this.s3Client;
        }
        if (this.beanFactory != null) {
            S3Client s3Client;
            this.s3Client = s3Client = (S3Client)this.beanFactory.getBean(S3Client.class);
            return s3Client;
        }
        return null;
    }
}

