/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class Location {
    private static final String S3_PROTOCOL_PREFIX = "s3://";
    private static final String PATH_DELIMITER = "/";
    private static final String VERSION_DELIMITER = "^";
    private final String bucket;
    private final String object;
    @Nullable
    private final String version;

    static Location of(String location) {
        return new Location(location);
    }

    Location(String bucket, String object) {
        this(bucket, object, null);
    }

    Location(String bucket, String object, @Nullable String version) {
        Assert.notNull((Object)bucket, (String)"bucket is required");
        Assert.notNull((Object)object, (String)"object is required");
        this.bucket = bucket;
        this.object = object;
        this.version = version;
    }

    private Location(String location) {
        Assert.notNull((Object)location, (String)"location is required");
        this.bucket = Location.resolveBucketName(location);
        this.object = Location.resolveObjectName(location);
        this.version = Location.resolveVersionId(location);
    }

    String getBucket() {
        return this.bucket;
    }

    String getObject() {
        return this.object;
    }

    @Nullable
    String getVersion() {
        return this.version;
    }

    public String toString() {
        return "Location{bucket='" + this.bucket + '\'' + ", object='" + this.object + '\'' + ", version='" + this.version + '\'' + '}';
    }

    static boolean isSimpleStorageResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        return location.toLowerCase().startsWith(S3_PROTOCOL_PREFIX);
    }

    private static String resolveBucketName(String location) {
        int bucketEndIndex = location.indexOf(PATH_DELIMITER, S3_PROTOCOL_PREFIX.length());
        if (bucketEndIndex == -1 || bucketEndIndex == S3_PROTOCOL_PREFIX.length()) {
            throw new IllegalArgumentException("The location :'" + location + "' does not contain a valid bucket name");
        }
        return location.substring(S3_PROTOCOL_PREFIX.length(), bucketEndIndex);
    }

    private static String resolveObjectName(String location) {
        int bucketEndIndex = location.indexOf(PATH_DELIMITER, S3_PROTOCOL_PREFIX.length());
        if (bucketEndIndex == -1 || bucketEndIndex == S3_PROTOCOL_PREFIX.length()) {
            throw new IllegalArgumentException("The location :'" + location + "' does not contain a valid bucket name");
        }
        if (location.contains(VERSION_DELIMITER)) {
            return Location.resolveObjectName(location.substring(0, location.indexOf(VERSION_DELIMITER)));
        }
        int endIndex = location.length();
        if (location.endsWith(PATH_DELIMITER)) {
            --endIndex;
        }
        if (bucketEndIndex >= endIndex) {
            return "";
        }
        return location.substring(++bucketEndIndex, endIndex);
    }

    @Nullable
    private static String resolveVersionId(String location) {
        int objectNameEndIndex = location.indexOf(VERSION_DELIMITER, S3_PROTOCOL_PREFIX.length());
        if (objectNameEndIndex == -1 || location.endsWith(VERSION_DELIMITER)) {
            return null;
        }
        if (objectNameEndIndex == S3_PROTOCOL_PREFIX.length()) {
            throw new IllegalArgumentException("The location :'" + location + "' does not contain a valid bucket name");
        }
        return location.substring(++objectNameEndIndex, location.length());
    }
}

