/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.parameterstore;

import io.awspring.cloud.core.config.AwsPropertySource;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;

public class ParameterStorePropertySource
extends AwsPropertySource<ParameterStorePropertySource, SsmClient> {
    private static Log LOG = LogFactory.getLog(ParameterStorePropertySource.class);
    private static final String PREFIX_PART = "?prefix=";
    private final String context;
    private final String parameterPath;
    @Nullable
    private final String prefix;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public ParameterStorePropertySource(String context, SsmClient ssmClient) {
        super("aws-parameterstore:" + context, (Object)ssmClient);
        this.context = context;
        this.parameterPath = ParameterStorePropertySource.resolveParameterPath(context);
        this.prefix = ParameterStorePropertySource.resolvePrefix(context);
    }

    public void init() {
        GetParametersByPathRequest paramsRequest = (GetParametersByPathRequest)GetParametersByPathRequest.builder().path(this.parameterPath).recursive(Boolean.valueOf(true)).withDecryption(Boolean.valueOf(true)).build();
        this.getParameters(paramsRequest);
    }

    public ParameterStorePropertySource copy() {
        return new ParameterStorePropertySource(this.context, (SsmClient)this.source);
    }

    public String[] getPropertyNames() {
        return (String[])this.properties.keySet().stream().toArray(String[]::new);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void getParameters(GetParametersByPathRequest paramsRequest) {
        GetParametersByPathResponse paramsResult = ((SsmClient)this.source).getParametersByPath(paramsRequest);
        for (Parameter parameter : paramsResult.parameters()) {
            String key = parameter.name().replace(this.parameterPath, "").replace('/', '.').replaceAll("_(\\d)_", "[$1]");
            LOG.debug((Object)("Populating property retrieved from AWS Parameter Store: " + key));
            String propertyKey = this.prefix != null ? this.prefix + key : key;
            this.properties.put(propertyKey, parameter.value());
        }
        if (paramsResult.nextToken() != null) {
            this.getParameters((GetParametersByPathRequest)paramsRequest.toBuilder().nextToken(paramsResult.nextToken()).build());
        }
    }

    @Nullable
    String getPrefix() {
        return this.prefix;
    }

    String getContext() {
        return this.context;
    }

    String getParameterPath() {
        return this.parameterPath;
    }

    @Nullable
    private static String resolvePrefix(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(prefixIndex + PREFIX_PART.length());
        }
        return null;
    }

    private static String resolveParameterPath(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(0, prefixIndex);
        }
        return context;
    }
}

