/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.CachingDestinationResolverProxy;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.core.MessagePostProcessor;

public abstract class AbstractMessageChannelMessagingSendingTemplate<D extends MessageChannel>
extends AbstractMessageSendingTemplate<D>
implements DestinationResolvingMessageSendingOperations<D> {
    private final DestinationResolver<String> destinationResolver;

    protected AbstractMessageChannelMessagingSendingTemplate(DestinationResolver<String> destinationResolver) {
        this.destinationResolver = new CachingDestinationResolverProxy(destinationResolver);
    }

    public void setDefaultDestinationName(String defaultDestination) {
        super.setDefaultDestination(this.resolveMessageChannelByLogicalName(defaultDestination));
    }

    protected void doSend(D destination, Message<?> message) {
        destination.send(message);
    }

    public void send(String destinationName, Message<?> message) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.doSend(channel, message);
    }

    public <T> void convertAndSend(String destinationName, T payload) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload);
    }

    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, headers);
    }

    public <T> void convertAndSend(String destinationName, T payload, MessagePostProcessor postProcessor) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, postProcessor);
    }

    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers, MessagePostProcessor postProcessor) throws MessagingException {
        D channel = this.resolveMessageChannelByLogicalName(destinationName);
        this.convertAndSend(channel, payload, headers, postProcessor);
    }

    protected D resolveMessageChannelByLogicalName(String destination) {
        String physicalResourceId = (String)this.destinationResolver.resolveDestination(destination);
        return this.resolveMessageChannel(physicalResourceId);
    }

    protected void initMessageConverter(MessageConverter messageConverter) {
        this.initMessageConverter(messageConverter, null);
    }

    protected void initMessageConverter(MessageConverter messageConverter, ObjectMapper objectMapper) {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(stringMessageConverter);
        if (messageConverter != null) {
            messageConverters.add(messageConverter);
        } else {
            MappingJackson2MessageConverter mappingJackson2MessageConverter = new MappingJackson2MessageConverter();
            mappingJackson2MessageConverter.setSerializedPayloadClass(String.class);
            if (objectMapper != null) {
                mappingJackson2MessageConverter.setObjectMapper(objectMapper);
            }
            messageConverters.add(mappingJackson2MessageConverter);
        }
        this.setMessageConverter((MessageConverter)new CompositeMessageConverter(messageConverters));
    }

    protected abstract D resolveMessageChannel(String var1);
}

