/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.messaging.core.QueueMessageChannel;
import io.awspring.cloud.messaging.core.support.AbstractMessageChannelMessagingSendingTemplate;
import io.awspring.cloud.messaging.support.destination.DynamicQueueUrlDestinationResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.DestinationResolvingMessageReceivingOperations;

public class QueueMessagingTemplate
extends AbstractMessageChannelMessagingSendingTemplate<QueueMessageChannel>
implements DestinationResolvingMessageReceivingOperations<QueueMessageChannel> {
    private final AmazonSQSAsync amazonSqs;

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs) {
        this(amazonSqs, null, (ObjectMapper)null);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver) {
        this(amazonSqs, resourceIdResolver, (ObjectMapper)null);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver, MessageConverter messageConverter) {
        this(amazonSqs, new DynamicQueueUrlDestinationResolver((AmazonSQS)amazonSqs, resourceIdResolver), messageConverter);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, ResourceIdResolver resourceIdResolver, ObjectMapper objectMapper) {
        this(amazonSqs, new DynamicQueueUrlDestinationResolver((AmazonSQS)amazonSqs, resourceIdResolver), null, objectMapper);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, DestinationResolver<String> destinationResolver, MessageConverter messageConverter) {
        this(amazonSqs, destinationResolver, messageConverter, null);
    }

    public QueueMessagingTemplate(AmazonSQSAsync amazonSqs, DestinationResolver<String> destinationResolver, MessageConverter messageConverter, ObjectMapper objectMapper) {
        super(destinationResolver);
        this.amazonSqs = amazonSqs;
        this.initMessageConverter(messageConverter, objectMapper);
    }

    @Override
    protected QueueMessageChannel resolveMessageChannel(String physicalResourceIdentifier) {
        return new QueueMessageChannel(this.amazonSqs, physicalResourceIdentifier);
    }

    public Message<?> receive() throws MessagingException {
        return this.receive((QueueMessageChannel)((Object)this.getRequiredDefaultDestination()));
    }

    public Message<?> receive(QueueMessageChannel destination) throws MessagingException {
        return destination.receive();
    }

    public <T> T receiveAndConvert(Class<T> targetClass) throws MessagingException {
        return this.receiveAndConvert((QueueMessageChannel)((Object)this.getRequiredDefaultDestination()), targetClass);
    }

    public <T> T receiveAndConvert(QueueMessageChannel destination, Class<T> targetClass) throws MessagingException {
        Message<String> message = destination.receive();
        if (message != null) {
            return (T)this.getMessageConverter().fromMessage(message, targetClass);
        }
        return null;
    }

    public Message<?> receive(String destinationName) throws MessagingException {
        return ((QueueMessageChannel)((Object)this.resolveMessageChannelByLogicalName(destinationName))).receive();
    }

    public <T> T receiveAndConvert(String destinationName, Class<T> targetClass) throws MessagingException {
        QueueMessageChannel channel = (QueueMessageChannel)((Object)this.resolveMessageChannelByLogicalName(destinationName));
        return this.receiveAndConvert(channel, targetClass);
    }
}

