/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.listener;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteMessageHandler
implements AsyncHandler<DeleteMessageRequest, DeleteMessageResult> {
    private static final Logger logger = LoggerFactory.getLogger(DeleteMessageHandler.class);
    private final String receiptHandle;

    DeleteMessageHandler(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }

    public void onError(Exception exception) {
        logger.warn("An exception occurred while deleting '{}' receiptHandle", (Object)this.receiptHandle, (Object)exception);
    }

    public void onSuccess(DeleteMessageRequest request, DeleteMessageResult deleteMessageResult) {
        logger.trace("'{}' receiptHandle is deleted successfully", (Object)request.getReceiptHandle());
    }
}

