/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.rds;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.ListTagsForResourceRequest;
import com.amazonaws.services.rds.model.ListTagsForResourceResult;
import com.amazonaws.services.rds.model.Tag;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.naming.AmazonResourceName;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class AmazonRdsDataSourceUserTagsFactoryBean
extends AbstractFactoryBean<Map<String, String>> {
    private final AmazonRDS amazonRds;
    private final String dbInstanceIdentifier;
    private final AmazonIdentityManagement identityManagement;
    private ResourceIdResolver resourceIdResolver;
    private Region region;

    public AmazonRdsDataSourceUserTagsFactoryBean(AmazonRDS amazonRds, String dbInstanceIdentifier, AmazonIdentityManagement identityManagement) {
        this.amazonRds = amazonRds;
        this.dbInstanceIdentifier = dbInstanceIdentifier;
        this.identityManagement = identityManagement;
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, String> createInstance() throws Exception {
        LinkedHashMap<String, String> userTags = new LinkedHashMap<String, String>();
        ListTagsForResourceResult tagsForResource = this.amazonRds.listTagsForResource(new ListTagsForResourceRequest().withResourceName(this.getDbInstanceResourceName()));
        for (Tag tag : tagsForResource.getTagList()) {
            userTags.put(tag.getKey(), tag.getValue());
        }
        return userTags;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    private String getDbInstanceIdentifier() {
        return this.resourceIdResolver != null ? this.resourceIdResolver.resolveToPhysicalResourceId(this.dbInstanceIdentifier) : this.dbInstanceIdentifier;
    }

    private Region getRegion() {
        if (this.region != null) {
            return this.region;
        }
        return Region.getRegion((Regions)Regions.DEFAULT_REGION);
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    private String getDbInstanceResourceName() {
        String userArn = this.identityManagement.getUser().getUser().getArn();
        AmazonResourceName userResourceName = AmazonResourceName.fromString((String)userArn);
        AmazonResourceName dbResourceArn = new AmazonResourceName.Builder().withService("rds").withRegion(this.getRegion()).withAccount(userResourceName.getAccount()).withResourceType("db").withResourceName(this.getDbInstanceIdentifier()).withResourceTypeDelimiter(":").build();
        return dbResourceArn.toString();
    }
}

