/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DynamoDbTableSchemaResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;

public class DefaultDynamoDbTableSchemaResolver
implements DynamoDbTableSchemaResolver {
    private final Map<Class<?>, TableSchema> tableSchemaCache = new ConcurrentHashMap();

    public DefaultDynamoDbTableSchemaResolver() {
        this(Collections.emptyList());
    }

    public DefaultDynamoDbTableSchemaResolver(List<TableSchema<?>> tableSchemas) {
        for (TableSchema<?> tableSchema : tableSchemas) {
            this.tableSchemaCache.put(tableSchema.itemType().rawClass(), tableSchema);
        }
    }

    @Override
    public <T> TableSchema<T> resolve(Class<T> clazz) {
        return this.tableSchemaCache.computeIfAbsent(clazz, TableSchema::fromBean);
    }

    Map<Class<?>, TableSchema> getTableSchemaCache() {
        return this.tableSchemaCache;
    }
}

