/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.docker.compose;

import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.docker.compose.LocalStackEnvironment;
import java.net.URI;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class AwsDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<AwsConnectionDetails> {
    private static final String[] LOCALSTACK_CONTAINER_NAMES = new String[]{"localstack/localstack", "localstack/localstack-pro"};
    private static final int LOCALSTACK_PORT = 4566;

    AwsDockerComposeConnectionDetailsFactory() {
        super(LOCALSTACK_CONTAINER_NAMES, new String[0]);
    }

    protected AwsConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new AwsDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class AwsDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements AwsConnectionDetails {
        private final LocalStackEnvironment environment;
        private final URI endpoint;

        private AwsDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new LocalStackEnvironment(service.env());
            this.endpoint = URI.create("http://%s:%s".formatted(service.host(), service.ports().get(4566)));
        }

        public URI getEndpoint() {
            return this.endpoint;
        }

        public String getRegion() {
            return this.environment.getRegion();
        }

        public String getAccessKey() {
            return this.environment.getAccessKey();
        }

        public String getSecretKey() {
            return this.environment.getSecretKey();
        }
    }
}

