/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3.properties;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3ConfigProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3CrtClientProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3EncryptionProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3PluginProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3TransferManagerProperties;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import software.amazon.awssdk.services.s3.S3Configuration;

@ConfigurationProperties(prefix="spring.cloud.aws.s3")
public class S3Properties
extends AwsClientProperties {
    public static final String PREFIX = "spring.cloud.aws.s3";
    private @Nullable Boolean accelerateModeEnabled;
    private @Nullable Boolean checksumValidationEnabled;
    private @Nullable Boolean chunkedEncodingEnabled;
    private @Nullable Boolean pathStyleAccessEnabled;
    private @Nullable Boolean useArnRegionEnabled;
    private @Nullable Boolean crossRegionEnabled;
    @NestedConfigurationProperty
    private @Nullable S3TransferManagerProperties transferManager;
    @NestedConfigurationProperty
    private @Nullable S3CrtClientProperties crt;
    @NestedConfigurationProperty
    private S3PluginProperties plugin = new S3PluginProperties();
    @NestedConfigurationProperty
    private S3EncryptionProperties encryption = new S3EncryptionProperties();
    @NestedConfigurationProperty
    private S3ConfigProperties config = new S3ConfigProperties();

    public S3EncryptionProperties getEncryption() {
        return this.encryption;
    }

    public void setEncryption(S3EncryptionProperties encryption) {
        this.encryption = encryption;
    }

    public S3ConfigProperties getConfig() {
        return this.config;
    }

    public void setConfig(S3ConfigProperties config) {
        this.config = config;
    }

    public @Nullable Boolean getAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(@Nullable Boolean accelerateModeEnabled) {
        this.accelerateModeEnabled = accelerateModeEnabled;
    }

    public @Nullable Boolean getChecksumValidationEnabled() {
        return this.checksumValidationEnabled;
    }

    public void setChecksumValidationEnabled(@Nullable Boolean checksumValidationEnabled) {
        this.checksumValidationEnabled = checksumValidationEnabled;
    }

    public @Nullable Boolean getChunkedEncodingEnabled() {
        return this.chunkedEncodingEnabled;
    }

    public void setChunkedEncodingEnabled(@Nullable Boolean chunkedEncodingEnabled) {
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    public @Nullable Boolean getPathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public void setPathStyleAccessEnabled(@Nullable Boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    public @Nullable Boolean getUseArnRegionEnabled() {
        return this.useArnRegionEnabled;
    }

    public void setUseArnRegionEnabled(@Nullable Boolean useArnRegionEnabled) {
        this.useArnRegionEnabled = useArnRegionEnabled;
    }

    public @Nullable Boolean getCrossRegionEnabled() {
        return this.crossRegionEnabled;
    }

    public void setCrossRegionEnabled(@Nullable Boolean crossRegionEnabled) {
        this.crossRegionEnabled = crossRegionEnabled;
    }

    public @Nullable S3TransferManagerProperties getTransferManager() {
        return this.transferManager;
    }

    public void setTransferManager(@Nullable S3TransferManagerProperties transferManager) {
        this.transferManager = transferManager;
    }

    public @Nullable S3CrtClientProperties getCrt() {
        return this.crt;
    }

    public void setCrt(@Nullable S3CrtClientProperties crt) {
        this.crt = crt;
    }

    public S3Configuration toS3Configuration() {
        S3Configuration.Builder config = S3Configuration.builder();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(this::getAccelerateModeEnabled).to(arg_0 -> ((S3Configuration.Builder)config).accelerateModeEnabled(arg_0));
        propertyMapper.from(this::getChecksumValidationEnabled).to(arg_0 -> ((S3Configuration.Builder)config).checksumValidationEnabled(arg_0));
        propertyMapper.from(this::getChunkedEncodingEnabled).to(arg_0 -> ((S3Configuration.Builder)config).chunkedEncodingEnabled(arg_0));
        propertyMapper.from(this::getPathStyleAccessEnabled).to(arg_0 -> ((S3Configuration.Builder)config).pathStyleAccessEnabled(arg_0));
        propertyMapper.from(this::getUseArnRegionEnabled).to(arg_0 -> ((S3Configuration.Builder)config).useArnRegionEnabled(arg_0));
        return (S3Configuration)config.build();
    }

    public S3PluginProperties getPlugin() {
        return this.plugin;
    }

    public void setPlugin(S3PluginProperties plugin) {
        this.plugin = plugin;
    }
}

