/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.config.secretsmanager.AwsSecretsManagerPropertySourceNotFoundException;
import io.awspring.cloud.secretsmanager.SecretsManagerPropertySource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public class SecretsManagerPropertySources {
    private static Log LOG = LogFactory.getLog(SecretsManagerPropertySources.class);

    @Nullable
    public SecretsManagerPropertySource createPropertySource(String context, boolean optional, SecretsManagerClient client) {
        Assert.notNull((Object)context, (String)"context is required");
        Assert.notNull((Object)client, (String)"SecretsManagerClient is required");
        LOG.info((Object)("Loading secrets from AWS Secret Manager secret with name: " + context + ", optional: " + optional));
        try {
            SecretsManagerPropertySource propertySource = new SecretsManagerPropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load AWS secret from " + context + ". " + e.getMessage()));
            if (!optional) {
                throw new AwsSecretsManagerPropertySourceNotFoundException(e);
            }
            return null;
        }
    }
}

