/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.config.AbstractAwsConfigDataLocationResolver;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerClientCustomizer;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerConfigDataResource;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerKeysMissingException;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerProperties;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerPropertySources;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.RegionProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class SecretsManagerConfigDataLocationResolver
extends AbstractAwsConfigDataLocationResolver<SecretsManagerConfigDataResource> {
    public static final String PREFIX = "aws-secretsmanager:";
    private final Log log;

    public SecretsManagerConfigDataLocationResolver(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(SecretsManagerConfigDataLocationResolver.class);
    }

    @Override
    protected String getPrefix() {
        return PREFIX;
    }

    @Override
    public List<SecretsManagerConfigDataResource> resolve(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        SecretsManagerProperties secretsManagerProperties = this.loadProperties(resolverContext.getBinder());
        List<String> contexts = this.getCustomContexts(location.getNonPrefixedValue(PREFIX));
        ArrayList<SecretsManagerConfigDataResource> locations = new ArrayList<SecretsManagerConfigDataResource>();
        SecretsManagerPropertySources propertySources = new SecretsManagerPropertySources();
        if (secretsManagerProperties.isEnabled()) {
            this.registerBean(resolverContext, AwsProperties.class, this.loadAwsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, SecretsManagerProperties.class, secretsManagerProperties);
            this.registerBean(resolverContext, CredentialsProperties.class, this.loadCredentialsProperties(resolverContext.getBinder()));
            this.registerBean(resolverContext, RegionProperties.class, this.loadRegionProperties(resolverContext.getBinder()));
            this.registerAndPromoteBean(resolverContext, SecretsManagerClient.class, this::createAwsSecretsManagerClient);
            contexts.forEach(propertySourceContext -> locations.add(new SecretsManagerConfigDataResource((String)propertySourceContext, location.isOptional(), propertySources)));
            if (!location.isOptional() && locations.isEmpty()) {
                throw new SecretsManagerKeysMissingException("No Secrets Manager keys provided in `spring.config.import=aws-secretsmanager:` configuration.");
            }
        } else {
            contexts.forEach(propertySourceContext -> locations.add(new SecretsManagerConfigDataResource((String)propertySourceContext, location.isOptional(), false, propertySources)));
        }
        return locations;
    }

    protected SecretsManagerClient createAwsSecretsManagerClient(BootstrapContext context) {
        SecretsManagerClientBuilder builder = this.configure(SecretsManagerClient.builder(), (AwsClientProperties)context.get(SecretsManagerProperties.class), context);
        try {
            AwsSyncClientCustomizer awsSyncClientCustomizer = (AwsSyncClientCustomizer)context.get(AwsSyncClientCustomizer.class);
            if (awsSyncClientCustomizer != null) {
                awsSyncClientCustomizer.customize((AwsSyncClientBuilder<?, ?>)builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type AwsSyncClientCustomizer is not registered: " + e.getMessage()));
        }
        try {
            SecretsManagerClientCustomizer secretsManagerClientCustomizer = (SecretsManagerClientCustomizer)context.get(SecretsManagerClientCustomizer.class);
            if (secretsManagerClientCustomizer != null) {
                secretsManagerClientCustomizer.customize(builder);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Bean of type SecretsManagerClientCustomizer is not registered: " + e.getMessage()));
        }
        return (SecretsManagerClient)builder.build();
    }

    protected SecretsManagerProperties loadProperties(Binder binder) {
        return (SecretsManagerProperties)binder.bind("spring.cloud.aws.secretsmanager", Bindable.of(SecretsManagerProperties.class)).orElseGet(SecretsManagerProperties::new);
    }
}

