/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.parameterstore;

import io.awspring.cloud.autoconfigure.config.parameterstore.AwsParameterPropertySourceNotFoundException;
import io.awspring.cloud.parameterstore.ParameterStorePropertySource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.ssm.SsmClient;

public class ParameterStorePropertySources {
    private static Log LOG = LogFactory.getLog(ParameterStorePropertySources.class);

    @Nullable
    public ParameterStorePropertySource createPropertySource(String context, boolean optional, SsmClient client) {
        Assert.notNull((Object)context, (String)"context is required");
        Assert.notNull((Object)client, (String)"SsmClient is required");
        LOG.info((Object)("Loading property from AWS Parameter Store with name: " + context + ", optional: " + optional));
        try {
            ParameterStorePropertySource propertySource = new ParameterStorePropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load AWS parameter from " + context + ". " + e.getMessage()));
            if (!optional) {
                throw new AwsParameterPropertySourceNotFoundException(e);
            }
            return null;
        }
    }
}

