/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.reload;

import io.awspring.cloud.autoconfigure.config.reload.ReloadProperties;
import io.awspring.cloud.autoconfigure.config.reload.ReloadStrategy;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.util.Assert;

public class ConfigurationUpdateStrategy
implements Runnable {
    private final Runnable reloadProcedure;

    public static ConfigurationUpdateStrategy create(ReloadProperties reloadProperties, ContextRefresher refresher, Optional<RestartEndpoint> restarter) {
        ReloadStrategy strategy = reloadProperties.getStrategy();
        if (strategy != null) {
            switch (strategy) {
                case RESTART_CONTEXT: {
                    restarter.orElseThrow(() -> new AssertionError((Object)"Restart endpoint is not enabled"));
                    return new ConfigurationUpdateStrategy(() -> {
                        ConfigurationUpdateStrategy.wait(reloadProperties);
                        ((RestartEndpoint)restarter.get()).restart();
                    });
                }
                case REFRESH: {
                    return new ConfigurationUpdateStrategy(() -> ((ContextRefresher)refresher).refresh());
                }
            }
            throw new IllegalStateException("Unsupported configuration update strategy: " + strategy);
        }
        throw new IllegalStateException("Configuration update strategy not set");
    }

    private ConfigurationUpdateStrategy(Runnable reloadProcedure) {
        Assert.notNull((Object)reloadProcedure, (String)"reloadProcedure cannot be null");
        this.reloadProcedure = reloadProcedure;
    }

    @Override
    public void run() {
        this.reloadProcedure.run();
    }

    private static void wait(ReloadProperties properties) {
        long waitMillis = ThreadLocalRandom.current().nextLong(properties.getMaxWaitForRestart().toMillis());
        try {
            Thread.sleep(waitMillis);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }
}

