/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.metrics;

import io.awspring.cloud.autoconfigure.AwsAsyncClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchAsyncClientCustomizer;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchProperties;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchPropertiesConfigAdapter;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchRegistryProperties;
import io.micrometer.cloudwatch2.CloudWatchConfig;
import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;

@AutoConfiguration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class, MetricsAutoConfiguration.class})
@EnableConfigurationProperties(value={CloudWatchRegistryProperties.class, CloudWatchProperties.class})
@ConditionalOnProperty(prefix="management.cloudwatch.metrics.export", name={"namespace"})
@ConditionalOnClass(value={CloudWatchAsyncClient.class, CloudWatchMeterRegistry.class, AwsRegionProvider.class})
public class CloudWatchExportAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.aws.cloudwatch.enabled"}, matchIfMissing=true)
    public CloudWatchMeterRegistry cloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, CloudWatchAsyncClient client) {
        return new CloudWatchMeterRegistry(config, clock, client);
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudWatchAsyncClient cloudWatchAsyncClient(CloudWatchProperties properties, AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<CloudWatchAsyncClientBuilder>> configurer, ObjectProvider<AwsConnectionDetails> connectionDetails, ObjectProvider<CloudWatchAsyncClientCustomizer> cloudWatchAsyncClientCustomizers, ObjectProvider<AwsAsyncClientCustomizer> awsAsyncClientCustomizers) {
        return (CloudWatchAsyncClient)awsClientBuilderConfigurer.configureAsyncClient(CloudWatchAsyncClient.builder(), properties, (AwsConnectionDetails)connectionDetails.getIfAvailable(), (AwsClientCustomizer)configurer.getIfAvailable(), cloudWatchAsyncClientCustomizers.orderedStream(), awsAsyncClientCustomizers.orderedStream()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudWatchConfig cloudWatchConfig(CloudWatchRegistryProperties cloudWatchProperties) {
        return new CloudWatchPropertiesConfigAdapter(cloudWatchProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

