/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.reload;

import io.awspring.cloud.autoconfigure.config.reload.ConfigurationUpdateStrategy;
import io.awspring.cloud.autoconfigure.config.reload.ReloadProperties;
import io.awspring.cloud.core.config.AwsPropertySource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.log.LogAccessor;

public abstract class ConfigurationChangeDetector<T extends AwsPropertySource<?, ?>> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigurationChangeDetector.class));
    protected ReloadProperties properties;
    protected ConfigurationUpdateStrategy strategy;
    protected ConfigurableEnvironment environment;
    private final Class<T> propertySourceClass;

    public ConfigurationChangeDetector(ReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurableEnvironment environment, Class<T> propertySourceClass) {
        this.properties = Objects.requireNonNull(properties);
        this.strategy = Objects.requireNonNull(strategy);
        this.environment = environment;
        this.propertySourceClass = propertySourceClass;
    }

    public void reloadProperties() {
        LOG.info(() -> "Reloading using strategy: " + this.strategy);
        this.strategy.run();
    }

    protected boolean changed(EnumerablePropertySource<?> left, EnumerablePropertySource<?> right) {
        if (left == right) {
            return false;
        }
        for (String property : left.getPropertyNames()) {
            if (Objects.equals(left.getProperty(property), right.getProperty(property))) continue;
            return true;
        }
        return false;
    }

    protected List<T> locateMapPropertySources(ConfigurableEnvironment environment) {
        return environment.getPropertySources().stream().filter(it -> it.getClass().isAssignableFrom(this.propertySourceClass)).map(it -> (AwsPropertySource)it).collect(Collectors.toList());
    }

    public Class<T> getPropertySourceClass() {
        return this.propertySourceClass;
    }
}

